function GenNoises
%Generate a Noise, changing magnitude shape in time and write it in a file

addpath('../../ShefFuns')

%
nb=6;       %n of bits, possibles noises (the number of possible formants is (nb-1)/2)
p=80;       %The more value the more precission in following the most dificult shape (1 0 1 0 ..) 
%(should be: 4*nb (if linear) 13*nb (if mel))
tav=800;   %time in samples of each noise (total signal should be at least 80000samp or 10seg)

%
nall=GetNoise(nb,tav,p); length(nall)
plot(nall)



%
nall=nall*2^15/max(abs(nall)); %To save in 16 bits format
raw_write_int16('./MAMel6b80p.08', nall, 'b');





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function nall=GetNoise(nb,tav,p)
%
Nn=3*2^nb; %N of short noises: To do appear all the possible noises (3*2^nb) 
nall=[];

for i=1:Nn
   M=GetMN(nb);
   t=round(tav*abs(randn(1)));  
   [fn, M]=FreqN(M,'mel');   
   n=ARMANoiseMS(fn,M,t,p);   
   nall=[nall n]; 
end


function M=GetMN(nb)
%Get Magnitud of Noise
%nb: number of bits (000 (silence), 011 (hp), 010 (bp), 101(rb),..)
%ns: number of samples (should be 2 or 4 times nb)
B = randn(1,nb)<0;
ns=26; %26 is the mel nch
y=round((0:ns-1)*(nb-1)/(ns-1))+1;
M= B(y)+0.01;


function [fn, M]=FreqN(M,kind)
%Freq Normalized in liner or mel space
switch kind
     case 'lin'
        l=length(M)-1; fn=(0:l)/l;
    case 'mel'
        fstart=64; fs=8000;
        nch=length(M);
        for i=0:nch+1 %i=0 (fstart), i=nch+1 (fs/2)
            fci(i+1)=InvMel(Mel(fstart)+i*(Mel(fs/2)-Mel(fstart))/(nch+1));
        end
        M=[M(1) M M(nch)];
        fn=[0 fci(1:nch)/(fs/2) 1];
end

    


function a=Mel(f)
a=2595*log10(1+f/700);

function f=InvMel(M)
f=700*(exp(M/2595*2.3026)-1);	


