function TrainFeatExtr(FeatDir,SpeechDBaseRoot,YDir,FeatK,P)
%Training Feature Extraction of the .wav in [SpeechDBaseRoot/YDir{i}]
%folders
%FeatDir: Result Root where features are saved
%[SpeechDBaseRoot/YDir{i}]:  speech folders
%FeatK: feature kind
%P: Parameter structure


for i=1:length(YDir)    
    dy=[SpeechDBaseRoot '/' YDir{i}];

    
    fy=dir([dy '/*' '.wav']); 
    
    
    for j=1:size(fy,1)
        
        %do and bn
        [pn,bn]=fileparts(fy(j).name);          
        do=[FeatDir '/' YDir{i}];
        
        %Read signal
        [y,x,P.FSamp]=ReSignal(SpeechDBaseRoot,YDir{i},bn); 
        
        %Derive parameters
        P=DerivParam(P);  
        [P.SpCond1,P.SpCond2]=fileparts(YDir{i});
        
        %Feat
        Y=Sign2Feat2(x,do,bn,P.GoodSpnHmmDir,FeatK,P); %we use clean signal
        
        %Save feat in HTK format
        WriteHTKF([do '/' bn '.Fbx'], Y, 0, 1);
        
        
    end
end