function Feat=Sign2Feat(y,P,k,do,bn)
%y: monaural signal

JuanKaldFeat='JuanFeat';

if nargin<3
    k='Fbank';
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if strcmp(JuanKaldFeat,'KaldFeat')

switch k    
    case 'Fbank'        
        Feat=Sign2KaldFeatGram(y,P.FSamp,'Fbank',do,bn,P);        
    case 'Mfcc'
        Feat=Sign2KaldFeatGram(y,P.FSamp,'Mfcc',do,bn,P);          
        
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
else
    

switch k
    
    case 'Y'
        [My nf]=Segmx(y,P.FL,P.FS);
        [Feat, CY]=Msd(My,'x',P.N2pi,P);
        
    case 'Fbank'
%         [CG,CGe]=CochlGram(y,P.FSamp,P.GamCFHz);   %0.15 sec
%         [A,An,r0]=CG2ACG(CG,P.nf,P);   %1 sec
%         Feat=log(sqrt(P.FL*r0/2)); Feat(Feat<P.MF)=P.MF;

        [My nf]=Segmx(y,P.FL,P.FS);
        [Y, CY]=Msd(My,'x',P.N2pi,P);
        Feat=SmoothFreqCompr(Y,P.NCH,P.FSamp,P.N2pi,P.MF);
        
        
        
        
     case 'Mfcc'
        [My nf]=Segmx(y,P.FL,P.FS);
        [Y, CY]=Msd(My,'x',P.N2pi,P);
        Fby=SmoothFreqCompr(Y,P.NCH,P.FSamp,P.N2pi,P.MF);           
        Feat=Fbank2Cepst(Fby,-1,P.CepL,0,1,0);
        %FeatD=AppDeltas(Feat,2,2,'feat');
        
        
end

end