function feats=AppContext(featsSingle,HWL)
%Append Context. HWL: Half Window Length (0 is the same, feats=featsSingle)


%conf{1}=[    -5    -4    -3    -2    -1     0     1     2     3     4     5]
%HWL=max(conf{1}); %Half widow lenght

conf1=-HWL:HWL;


% Find matrix dimension 
[D,T]=size(featsSingle);

% Initialize the output matrix
feats=zeros(length(conf1)*D,T);
featsSingle2=[repmat(featsSingle(:,1),[1,HWL]) featsSingle repmat(featsSingle(:,end),[1,HWL])];

% Append the context frames
for i=1:T % conf{1}=10; x=[xi; xi+1; ....; xi+10]
    start=i;
    ende=i+length(conf1)-1;    
    feats(:,i)=reshape(featsSingle2(:,start:ende),[D*length(conf1),1]);
end