function WriteHTKF(fn,M,HtkHead64bit,fprint)
%Write HTK Function
%For Htk I have been always using 32 bits
%Important be carefull with shape of M (only 1 column then only 1 frame)
%sampKind =   9 (User), 8262 (MFCC_0_E), 2886 (MFCC_E_D_A_Z) 


fid=fopen(fn,'w');
[nch nf]=size(M);

%To load one-dim vector in a correct way
if nf==1;   M=reshape(M,nf,nch);   [nch nf]=size(M); end
    

nSamples=nf;
sampSize=4*nch; 
sampPeriod= 100000;
sampKind=   9;


if (HtkHead64bit==1)
    fwrite(fid, nSamples,  'int64');
    fwrite(fid, sampPeriod, 'int64');
    fwrite(fid, sampSize, 'int16');
    fwrite(fid, sampKind, 'int16'); 
else    
    fwrite(fid, nSamples,  'int32');
    fwrite(fid, sampPeriod, 'int32');
    fwrite(fid, sampSize, 'int16');
    fwrite(fid, sampKind, 'int16');
end

fwrite(fid, M, 'float');

fclose(fid);
if(fprint==1); disp(['Writted ' fn]); end
