function M=ReadHTKF(fn,HtkHead64bit,BigEnd)
%Read HTK File 
%Be carefull!: if the EtsiFE or the program which writes HTKHead has been
% compiled for a 64bits machine (not used -m32 on gcc) 
% and my machine is 64bits, then c-long means matlab-int64 and c-short means
%This means the head does not have a correct HTK size

if (BigEnd == 1) %used by HCopy
  fid=fopen(fn,'r','b');
else	%used by Juan
  fid=fopen(fn,'r','l');
end

if (HtkHead64bit==1)
    nSamples=fread(fid, 1, 'int64'); 
    sampPeriod=fread(fid, 1, 'int64');
    sampSize=fread(fid, 1, 'int16');
    sampKind=fread(fid, 1, 'int16');
else
    nSamples=fread(fid, 1, 'int32');
    sampPeriod=fread(fid, 1, 'int32');
    sampSize=fread(fid, 1, 'int16');
    sampKind=fread(fid, 1, 'int16');
end


nch=sampSize/4;

if (sampKind==0)
    Ma=fread(fid,[inf], 'float');   
    for i=1:nch
        M(i,:)=Ma((i-1)*nSamples+1:i*nSamples);
    end   
else
    M=fread(fid,[nch inf], 'float');  
end


fclose(fid);
