function [y,P]=ReNormYX(dy,bn,P)
%Read Normalized (+-1 double) Y (noisy) and X (Clean) signals
%y: in a microphone array, each column correspond to each microphon. 
%The last column is the averaged monosignal or the reference microphone signal.
%


fny=[dy '/' bn P.YExt];
fnn=[P.dn '/' bn P.XExt];
%fnx=[P.dx '/' bn P.XExt];

fprintf('fny = %s\n',fny)


if (strcmp(P.YExt,'.wav'))
    [y,P.FSamp] = ReMWav(fny,0,0);       
    %[P.xm,xx] = ReMWav(fnx,size(y),P.FSamp);       
    [P.nm,xx] = ReMWav(fnn,size(y),P.FSamp);      
    %P.nm=-1;
    
  
    %P.Info = ReChi3Info(dy,bn,P); %a bit heavy!
    %Old: ns=Chime3Info2TrueNoise(P.Info);  
    %Old: P.Info      = ReEmbInfo([dy '/' bn '.txt']); 
  
    
elseif (strcmp(P.YExt,'.08')||strcmp(P.YExt,'.wv1'))    
    y       = ReInt162NDouble(fny,P.EndianFormat);
    P.x      = ReInt162NDouble(fnx,P.EndianFormat);   
    P.FSamp = 8000;
else
    disp('ERROR: Unknown SpeechDataBase')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function trans=GetTrans(bni,Dic)
%
BN=Dic.BN; 
WTrans=Dic.WTrans;

t=strcmp(bni,BN);
if sum(t)~=1
  trans='xx';
  fprintf('WARNING: fake transcription %s for %s\n',trans,bni);
else  
  trans=WTrans{t};  
end


function [x,fs]=ReSph(fn,wrd)
%Read Sphere format using voiceboox
[x,fs,wrd,phn,ffx]=readsph(fn); 


function [xo,fs]=ReMWav(fn,ysize,yfs)
%Read Matrix Wave file, fn: file name
if exist(fn,'file'); [xs,fs]=audioread(fn); 
else
    xs=NaN;
    warning('Invented %s\n',fn);
    fs=yfs;       
end




if (size(xs,2)==2); xo=[xs (xs(:,1)+xs(:,2))/2];
else xo=xs; end



