function [S]=ReEmbInfo(IF)
%Read Embbed Info July-2015

if(exist(IF,'file'))

    fi = fopen(IF);
    l = fgets(fi); i=1;
    while ischar(l)
        C=strsplit(l);   
        S(i).st=str2double(C{1}); 
        S(i).en=str2double(C{2}); 
        S(i).pos=C{3}; 
        S(i).bn=C{4}; 
        S(i).WTrans=sprintf('%s ',C{5:end});    
        l = fgets(fi); i=i+1;
    end
    fclose(fi);

    S=ChEmbInfoOv(S); 

else
    
    fprintf('WARNING in ReNormYX: Invented info %s\n',IF);
    S(1).st=-1; S(1).en=-1; S(1).pos='-1'; S(1).bn='-1'; S(1).WTrans='-1';
    
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=ChEmbInfoOv(SI) 
%Check EmbInfo Overlappings
S=SI;
l=length(S); lo=l;
i=1;
while i<=l
    o=FindOverl(i,S);
    S(o)=[];
    i=i+1;
    l=length(S);  
end
fprintf('Info reduced from %d to %d\n',lo,l);

function o=FindOverl(i,S)
%
%Actual
s=S(i).st; e=S(i).en; bn=S(i).bn; WT=S(i).WTrans;
Id=BN2Id(bn);

%Others
sv=StArFNExtract(S,'st'); ev=StArFNExtract(S,'en');
o=(s>=sv & s<=ev) | (e>=sv & s<=ev); 
o(i)=0; %we do not consider itself
SO=S(o);
lo=length(SO);

%
for j=1:lo        
    bno=SO(j).bn;
       
    Ido=BN2Id(bno);    
    WTo=SO(j).WTrans;    
    %fprintf('%s ovelap with %s\n',bn,bno);    
    if ~strcmp(Id,Ido); fprintf('WARNING: There is overlapping (%s, %s) but different Id\n',bn,bno); end           
    if ~strcmp(WT,WTo); fprintf('WARNING: There is overlapping but different WTrans\n'); end   
    
    
        
end

function Id=BN2Id(bn)
%
[pn,bn]=fileparts(bn);
C = strsplit(bn,'_');
Id=C{2};


