function Isol=Info2OrTSLoc(ym,xm,vad,FS,Info,DilSa)
%Info To Oracle Temp-Spatio Localizater
%ym: y matrix or multichannel

%Dilate
if nargin < 6; DilSa=0; end
if (DilSa~=0); fprintf('Oracle st and en increased %d samples\n',DilSa); end



%
nf=length(vad);
l=length(ym(:,1));

%
IsolL=length(Info);
for i=1:IsolL
    
    %
    st=max(1,Info(i).st-DilSa); en=min(l,Info(i).en+DilSa);
    
    %
    stfr=max(1,ceil(st/FS)); enfr=min(nf,ceil(en/FS));
    Isol(i).vad=vad(stfr:enfr);
    
    
    %
    Isol(i).st=st; Isol(i).en=en;    
    Isol(i).ym=ym(Isol(i).st:Isol(i).en,:);    
    Isol(i).xm=xm(Isol(i).st:Isol(i).en,:); 
    
    Isol(i).bn=Info(i).bn;     
    Isol(i).XPos=Info(i).pos;  
    Isol(i).XRoom=Isol(i).XPos(1);
    Isol(i).Room=Isol(i).XPos(1);
    Isol(i).WTrans=Info(i).WTrans;
    
    %Isol(i).Pos=Isol(i).XPos;
    %Isol(i).Room=Isol(i).XRoom;
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



