function [TG,Fby]=MaskAcTG(CG,CGe,P)
%Masked AutoCorrelogram ToneGram


%
[A,An,r0]=CG2ACG(CG,P.nf,P);   %1 sec       
Fby=log(sqrt(P.FL*r0/2)); Fby(Fby<P.MF)=P.MF;       
H=JuanHarmonicity(An,P);   %0.1 sec           
M=HarmEneMask(H,Fby,P);   


%
TInt=P.MiPitSa:P.MaPitSa;
[nch,nk,nf]=size(A); 
HTh=0.0;

% 
Anc=An(:,TInt+1,:); 
Ac=A(:,TInt+1,:);
H=Anc>HTh; 

%
[nch,pitl,nf]=size(H);
M2=zeros(nch,pitl,nf);
for i=1:pitl;  M2(:,i,:)=M; end
H=M2&H;

%
Ahc=zeros(size(Ac)); 
Ahc(H)=Ac(H); 
SAc=sum(Ahc); 
SHc=sum(H);
SAc=squeeze(SAc); SHc=squeeze(SHc); 

%
TG=zeros(P.MaPitSa,nf);
TG(TInt+1,:)=SAc;

TG=sqrt(TG); %amplitud-magnitude output







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function M=HarmEneMask(H,Fb,P)
%
FbM=MagOrdThr(exp(Fb));  
HM=H>0.0;
M=HM.*FbM;


