function py=VBoxPitch(y,P,HTh,VF,kind,x)
%VoiceBox pitch (RAPT or PEFAC)
%RAPT is the famous get_f0 wich Patricia Teller call
% VF  = 2;   % (2) voiced filter (for median fielter for binary detection of voiced frames)
% HTh = 0.70;  % (0.8) [0,1] Voiced Harmonicity Thr

fs=P.FSamp;

switch kind
    
    case 'Rapt'
        % % RAPT
        [fy,tt]=fxrapt(y,fs,'u');        
        py=fs./fy; v=~isnan(fy); v=ModeF(v*1,VF); py(~v)=0;
        % [fx,tt]=fxrapt(x,fs,'u');
        % px=fs./fx; v=~isnan(fx); v=ModeF(v*1,VF); px(~v)=0;

    case 'Pefac'
        %PEFAC
        [fy,ty,pvy,fvy]=fxpefac(y,fs,P.FSSec); pvy=sqrt(pvy);
        py=fs./fy; v=pvy>HTh; v=ModeF(v*1,VF); py(v==0)=0;
        %[fx,tx,pvx,fvx]=fxpefac(x,fs,P.FSSec); pvx=sqrt(pvx);
        %px=fs./fx; v=pvx>HTh; v=ModeF(v*1,VF); px(v==0)=0;
        
end
   

% subplot(211), plot(py), hold on, plot(fs./fy,'ro'), hold off,
% subplot(212), plot(pvy), hold on, plot(HTh*ones(1,length(py)),'r'), hold off,
% pause
