function psm=SmVADPit(porig,Rb,hfl,int,kind)
%Smooth VAD and correct Pit
%kind: n NoteMedPit; i InstMedPit

%
porig(1:hfl)=0; porig(end-hfl:end)=0;
p=porig; v=p~=0; vc=ModeF(v*1,hfl); vc=logical(vc); p(~vc)=0; 

% 
if kind=='n'; mp=NoteMedPit(p); end
if kind=='i'; mp=InstMedPit(p,hfl); end
hp=round(mp*int); lp=round(mp/int);
%
e=(p>hp | p<lp) & vc;
%
psm=p; nf=length(p);
for n=1:nf
    if (e(n)==1);
        [v p]=max(Rb(lp(n)+1:hp(n)+1,n));       
        psm(n)=p+lp(n)-1;        
    end
end

% subplot(211), imagesc(nthroot(Rb,3)), axis xy
% subplot(212), plot(psm), hold on, 
% plot(mp,'r'), plot(hp,'r'), plot(lp,'r'), 
% plot(porig,'ro'), xlim([1 nf]) 
% hold off, 
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function mp=InstMedPit(p,hfl)
%Instantanerous Median Pitch based on closest pitch
nf=length(p); v=p~=0; n=(1:nf)'; nv=n(v); 
inv=knnsearch(nv,n,'k',2*hfl+1); 
nsv=nv(inv)'; 
if (hfl==0); mp=p(nsv); 
else mp=median(p(nsv)); end


function mp=NoteMedPit(p)
%Note Median Pitch 
v=p~=0; pm=mean(p(v));
ini=1;
l=length(v);
mp=zeros(1,l);
for i=2:l-1
    if(v(i)==1 && v(i-1)==0); ini=i; end
    if(v(i)==1 && v(i+1)==0); 
        fin=i; 
        t=p(ini:fin); nz=t~=0; t=t(nz); if(isempty(t)); t=pm; end
        mp(ini:fin)=median(t);        
    end
end


