function [p,q] = dpfast_cons(M,C,rows,cols)
% DPFAST_CONS  DTW con puntos de anclaje.
%
% [P,Q] = DPFAST_CONS(M,C,ROWS,COLS)
%       M:      matriz de coste
%       C:      matriz de pasos (por defecto, [-1,1,1; 0,1,1; 1,1,1])
%       ROWS:   filas de anclaje
%       COLS:   columnas de anclaje
%       ----
%       P:      filas del camino
%       Q:      columnas del camino
%

if nargin<2 || isempty(C),
    C = [-1 1 1; 0 1 1; 1 1 1];
end

if nargin<3,
    rows = [];
    cols = [];
end

if isempty(cols),
    [p,q] = dpfast_var2(M,C,0);
    return;
end

[r,c] = size(M);

% Ordena valores segun columna
[cols,idx] = sort(cols);
rows = rows(idx);

if cols(1)~=1,
    cols = [1 cols];
    rows = [0 rows];
end
if cols(end)~=c,
    cols = [cols c];
    rows = [rows 0];
end

p = [];
q = [];

maxval = 10e99;

% Ejecuta dtw por partes
for i=1:length(cols)-1,
    if rows(i)~=0,
        M([1:rows(i)-1 rows(i)+1:r],cols(i)) = maxval;
    end
    if rows(i+1)~=0,
        T = r-rows(i+1)+1;
    else
        T = 0;
    end
    [paux,qaux] = dpfast_var2(M(:,cols(i):cols(i+1)),C,T);
    qaux = qaux + cols(i) - 1;
    if i==1,
        p = [p paux];
        q = [q qaux];
    else
        p = [p paux(2:end)];
        q = [q qaux(2:end)];
    end
end






