function M=MLines(labr,lab,Sl,MS,kind) 
%Matrix of Lines 
%IMPORTANT: with equal E line chose that which has min pitch
%(becaus of max) and it is also the correct.

i=lab>0; lab=lab(i); 
i=labr>0; labr=labr(i); 

if kind=='1'
    v=ones(1,length(lab)); vr=-1*ones(1,length(labr));
elseif kind=='E' %Energy (Sl.E is the mean line energy)
    v=Sl.E(lab); vr=Sl.E(labr);  
elseif kind=='T' %Total en.
    v=Sl.E(lab).*Sl.l(lab); vr=Sl.E(labr).*Sl.l(labr);          
elseif kind=='L' %Label
    v=Sl.lab(lab);  vr=Sl.lab(labr);
elseif kind=='I' %Instantaneous Energy
    v=Sl.EI(lab,:); vr=Sl.EI(labr,:);    
end

M=zeros(size(MS));
M=FillM(M,lab,Sl,v,kind);
M=FillM(M,labr,Sl,vr,kind);
 


       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function M=FillM(M,lab,Sl,v,kind)
%
[FL nf]=size(M);
nl=length(lab);
if kind=='I'
    
    for i=1:nl
        x=Sl.x(lab(i),:);  x(x==0)=1; y=round(Sl.py(lab(i),:)+1); 
        ind=sub2ind([FL nf],y,x); 
        M(ind)=v(i,1:length(ind)); 
    end

else

    for i=1:nl
        x=Sl.x(lab(i),:);  x(x==0)=1; y=round(Sl.py(lab(i),:)+1); 
        ind=sub2ind([FL nf],y,x); 
        M(ind)=v(i); 
    end
end




