function [cl,cm,ci,f]=CLimitMovimInten(xr,pyr,xc,pyc,Ir,Ic)
%Commom Limit, Moviment and Intensity between 2 lines
%xr, pyr: x, y vectors of r line (lm in paper)
%xc, pyc: x, y vectors of c line (lh in paper)
%Ir: r line intensity
%Ic: c line intensity

[xi,ir,ic]=intersect(xr,xc); %find common x
pr=pyr(ir); pc=pyc(ic);
f=mean(pc./pr); 
cm=1-sqrt(var(pr-pc/f))/10;
cl=1-(abs(xr(1)-xc(1))+abs(xr(end)-xc(end)))/length(xr);
ci=1-abs(Ic-Ir)/Ir; 


