function pit=DTWPitch(y,P,pxm)
%Tone Pitch
%Comput Speaker mean pitch (pym) if not given


PitP.pl=P.MiPitSa;
PitP.ph=P.MaPitSa;

PitP.flf=10; %first last frames to avoid pitch
PitP.feq=5; %factor for error quantization (see 0.1)
PitP.tho=[0.9 0.7 2]; %thr for possible octaves (see ci)
PitP.oma=6; %octave maximum

PitP.vf=5; %5 Energy variance factor
PitP.shl=4; %4 WL/10
PitP.WL=30; %30 Word length in BWRegion
PitP.fmai=1.5; %1.25 factor for max interval 



[TG,TGA]=AcTG(y,P);   
%TG=TunTGram(y,P); 


[BWr,Etg]=BWRegion(TG,PitP.WL,PitP.flf,PitP.pl); 
[Sdtw]=DTWLinFeat(TG,BWr);
[pymest,Smal]=MeanSpeakerPit(TG,Sdtw,PitP); 


if (nargin<3) 
    pym=pymest; 
else
    pym=pxm; 
end

pit=FinalPitSel2(Smal,pym,PitP.fmai,PitP.shl,TG);










