function Fbnest=VadPitN(My,Y,Fby,pit,vad,GSNR,P,N,Fbn)
%Vad Pitch Noise estimators

[nch nf]=size(Fby);


vad2=ones(1,nf); 
vad2(1:P.FLFr)=0; 
vad2(end-P.FLFr:end)=0; %vad2 (First Last Frame silence and rest unvoiced)



if (P.NoiseK==0)    %Vad2Noise, first-last frames noise
    fprintf('Vad2Noise, first-last frames noise ');
    vad=vad2;
    [VTN,VK]=VadNoise(Y,vad,P.FLFr);       
    
    
elseif (P.NoiseK==1)  %VadNoise, vad noise
    [VTN,VK]=VadNoise(Y,vad,P.FLFr);
	    
elseif (P.NoiseK==2)  %Vad2NoiseCeilTun
    vad=vad2;
    [VN,VK]=VadNoise(Y,vad,P.FLFr);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadCeilTunN(VN,VK,TN,TK,pit,GSNR,P);
    
elseif (P.NoiseK==3)    %VadNoiseCeilTun   
    [VN,VK]=VadNoise(Y,vad,P.FLFr);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadCeilTunN(VN,VK,TN,TK,pit,GSNR,P);
    
elseif (P.NoiseK==4)    %VadNoiseTun   
    [VN,VK]=VadNoise(Y,vad,P.FLFr);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadTunN(VN,VK,TN,TK,pit,GSNR,P);

elseif (P.NoiseK==5)    %MinStat  
    fprintf('MinStat ');
    VTN=MinStatN(Y,P.FSSec,'1'); 
    
elseif (P.NoiseK==6)    %MMSE  
    fprintf('MMSE ');
    VTN=MinStatN(Y,P.FSSec,'2');  
    
elseif (P.NoiseK==7)    %Oracle Noise (see below) 
    fprintf('Oracle Noise ');
    VTN=N;	
end




if (P.NoiseK~=7) %Smoothing	
	VTN=SmoothTime(VTN,P.SmL);
end

Fbnest=SmoothFreqCompr(VTN,P.NCH,P.FSamp,P.N2pi,P.MF);
 




%  FbV=SmoothFreqCompr(VN,P.NCH,P.FSamp,P.N2pi,P.MF);
%  FbT=SmoothFreqCompr(TN,P.NCH,P.FSamp,P.N2pi,P.MF);
%  subplot(511), imagesc(Fbn), axis xy
%  subplot(512), imagesc(FbV), axis xy
%  subplot(513), imagesc(FbT), axis xy
%  subplot(514), imagesc(Fbnest), axis xy
%  subplot(515), plot(pit), xlim([1 length(vad)])
%  pause


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [VTN]=VadCeilTunN(VN,VK,TN,TK,py,GSNR,P)
%
VTN=VN; i=(VTN>TN)&TK; VTN(i)=TN(i);


function [VTN]=VadTunN(VN,VK,TN,TK,py,GSNR,P)
%
VTN=VN;
if (GSNR<P.GSNRTh); VTN(TK)=TN(TK);
else i=(VTN>TN)&TK; VTN(i)=TN(i); end



function [TN,TK]=TunNoise(My,Y,pit,P)
%
TN=TunN(Y,My,pit,P.win,P.N2pi); 
TK=false(size(Y));  TK(:,pit>0)=1;





