function Nt=TunN(Y,My,pit,win,N2pi,FS,N,p,rat)
%Tunnelling Noise

[FL nf]=size(Y);

Nt=zeros(FL,nf);
%[Mya, lc]=ComplFrames(My,pit,FS);
%NFT=2*length(wrad);
%WinFL=abs(fft(win,NFT)/sqrt(FL));



for i=1:nf  
    if (pit(i)>1)        
        Nt(:,i)=NIntLin(My(:,i),pit(i),win,N2pi);        
        %subplot(211), PlotN(Nt(:,i),N(:,i), wrad);         
        
        %Nt(:,i)=NIntAR(Mya(1:lc(i),i),pit(i),WinFL,hamming(lc(i)),wrad,p,rat);
        %subplot(212), PlotN(Nt(:,i),N(:,i), wrad); pause     
        
        
    end     
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Spi]=NIntLin(x,T,win,N2pi)
%Noise Interpolation Linear
NFTh=1+N2pi/2; wrad=(0:NFTh-1)'*(2*pi/N2pi);
x=(x.*win);
kmax=floor(T*wrad(end-1)/(2*pi)-1/2);
wk=2*pi*((0:kmax)+1/2)/T; wk=[0 wk pi];
Spk=MSp(x,wk);
Spi=interp1(wk,Spk,wrad(2:end-1)); 
Spi=[Spk(1); Spi; Spk(end)];


function M=MSp(x,wk)
%Magn Spectr
lx=length(x);
n=0:lx-1;
l=length(wk); 
MR=zeros(l,lx); MI=zeros(l,lx); 
for i=1:l
    MR(i,:)=cos((n-lx/2)*wk(i)); 
    MI(i,:)=sin((n-lx/2)*wk(i));
end
R=MR*x; I=MI*x; 
M=sqrt((R.^2+I.^2)/lx);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PlotN(Nest,N,wrad)
plot(wrad,Nest,'r'), hold on, plot(wrad,N), hold off, 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Mya, lc]=ComplFrames(My,T,FS)
%Complete Frames. The max T should be 2*FS (160 samples)
[FL, nf]=size(My);
%Completed lenght
pit=round(T);
a=pit-mod(FL,pit);
c=pit-a;
i=a>c; a(i)=0; c(not(i))=0; i=a>FS; a(i)=FS;
lc=FL-c+a; lc(nf)=0;
%My All
Mya=zeros(FL+FS,nf); Mya(1:FL,:)=My(1:FL,:); Mya(FL+1:FL+FS,1:nf-1)=My(FL-FS+1:FL,2:nf);




function Nest=NIntAR(y,T,Win,win,wrad,p,rat)
%Nest: N est, y: noisy (should be completed), T: period of x (samples, can be float), 
%p: AR order. wrad: where the spectrum is obtained   
y=(y.*win); 
[Ns, ws]=NTSampl(y,T,wrad,'mid',rat);
Nest = IntSp(ws,Ns,wrad,p,'fir2'); 
%NFT1=length(Nest); Nest=ConvWin([Nest; Nest(NFT1:-1:1)],Win,length(y)); Nest=Nest(1:NFT1);



function XW=ConvWin(X,W,lx)
%X, W, XW from 0 to pi
NFT=length(W);
XW=cconv(X,W,NFT)/sqrt(NFT.^2/lx);


function Ny = IntSp(ws,Ns,wy,p,kind)
%Interpolation of Spectrum (AR or Lin) in wy using Ns (samples) to create the model with a
switch kind
    case 'fir2'          
        b=fir2(p,ws./pi,Ns'); 
        a=[1 zeros(1,p)];               
        [K,W] = meshgrid((0:p),wy); E=exp(-j*K.*W);  Ny=abs((E*b')./(E*a'));         
    case 'ma'    
        [K,W] = meshgrid((0:p),ws); E=exp(-j*K.*W); b=abs(Ns); a=E\b;
        [K,W] = meshgrid((0:p),wy); E=exp(-j*K.*W); Ny=abs((E*a));   
    case 'ar'
        [K,W] = meshgrid((0:p),ws); E=exp(-j*K.*W); b=abs(1./Ns); a=E\b;
        [K,W] = meshgrid((0:p),wy); E=exp(-j*K.*W); Ny=abs(1./(E*a));   
    case 'lin'       
        Ny=interp1(ws,abs(Ns),wy);      
end

function [Ns, ws]=NTSampl(y,T,wrad,kind,r)
%Noise Tunnelling Samples (0 and pi rad are always included) 
switch kind    
    case 'mid'
        kmax=floor(T*wrad(end)/(2*pi)-1/2);
        ws=2*pi*((0:kmax)+1/2)/T; ws=[0 ws pi];  
        Ns=MSp(y,ws);    
    case 'rat'
        %rat: 0.3 (is similar to mid but not exactly, don't use 0.5), 0 (similar to all)
        N=length(y); wy=0:2*pi/N:2*pi-2*pi/N; T=round(T);
        i=true(1,N);
        kx=(N/T)*(0:ceil(T/2));  d=round(r*N/T);
        kxi=kx-d; j=kxi<0; kxi(j)=0; kxi=kxi+1;
        kxf=kx+d; j=kxf>N-1; kxf(j)=N-1; kxf=kxf+1;
        l=length(kxi); for j=1:l; i(kxi(j):kxf(j))=0; end    
        i(ceil(N/2)+1:end)=0;         
        ws=[0 wy(i) pi]; 
        Ns=MSp(y,ws);  
       
               
end





