function ys=Mono2SimHouse(y,yFSamp,Pos,ysFSamp,Mic,TailPer)
% Mono To Simulate House
%y:         Monaural input
%yFSamp:    SampF of y
%Pos:       Position of ys. 'LAO2' or simply 'L'
%ysFSamp:   SampF of ys
%Mic:       Microphones. Mic={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'};
%ys:        Stereo Multichannel output
%TailPer:   TailPercentage (if 0 or not given then length of output =
%length input)

%
AR={'K' 'L' 'R' 'C' 'B'}; %All Rooms
E={'K' 'L'; 'L' 'C'; 'C' 'R'; 'C' 'B'}; %Edges of the Room Graph
D=[4;        4;       3     ;  3]; %Corresponding distant to the Room Graphs


%
bg=Edg2NoDiBioGr(E,D,AR);
a=RoomNa2Num(Pos(1),AR);
ns=length(y);
nr=length(Mic);
ys=zeros(ns,nr);

for i=1:nr
   b=RoomNa2Num(Mic{i}(1),AR);   
   [dist, path, pred]=shortestpath(bg, a, b);   
   [ga,de]=Dist2GaDe(dist,yFSamp);
   ys(de+1:ns,i)=ga*DelSign(y,de);
   
   %Pos(1), Mic{i}(1);  [dist, ga, de];   pause
   
end

%Resample yFSamp -> ysFSamp (to be done)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function yd=DelSign(y,de)
%Delay signal
ns=length(y);
yd=zeros(ns,1);
if de>=0
    yd(de+1:ns)=y(1:ns-de);
else    
    yd(1:ns-abs(de))=y(abs(de)+1:ns);
end


function [ga,de]=Dist2GaDe(di,FSamp)
%Distant To Gain and Delay
ga=1/(1+0.1*di^2);
de=round(FSamp*(di/340));

function bg=Edg2NoDiBioGr(E,D,AR)
%Edges To No Direction BioGr
%E={'K' 'L'; 'L' 'C'; 'C' 'R'; 'C' 'B'}; %Edges of the Room Graph
%D=[4;        4;       3     ;  3]; 
%MaV: Max Vertice
CM=zeros(length(AR));
l=length(E);
for i=1:l
    a=RoomNa2Num(E(i,1),AR);
    b=RoomNa2Num(E(i,2),AR);
    CM(a,b)=D(i);
    CM(b,a)=D(i);
end
bg=biograph(CM,AR);
%view(bg); pause

function N=RoomNa2Num(R,AR)
%RoomName To Number
AN=1:length(AR);
i=strcmp(R,AR); 
N=AN(i);



