function [ys]=Mono2FBKMicArr(y,yFSamp,Pos,ysFSamp,Mic,TailPer)
%Monoaural To FBK MicArray signal
%y:         Monaural input
%yFSamp:    SampF of y
%Pos:       Position of ys
%ysFSamp:   SampF of ys
%Mic:       Microphones. Mic={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'};
%ys:        Stereo Multichannel output
%TailPer:   TailPercentage (if 0 or not given then length of output =
%length input)


%Parameters
%IRRoot='/afs/spsc.tugraz.at/resources/databases/INCOMING/DIRHA_FBK_sim/DIRHA_sim2_v3/Docs/IRs/mat'; 
IRRoot='/home/jmorales/SpeechData/FBKGEDIRHA_All/ITEA/IRs/mat'; %where we can find folders LA, LB, ..


if (nargin<6)
    TailPer=0;
end    

IRFSamp=48000;


%Read Impulse Responses of the corresponding position (if direction Pos(3:4) not
%given choose randomly)
IRDirB=[IRRoot '/' Pos(1:2)];
if length(Pos)<3
    a=dir([IRDirB '/O*']); r=randi(length(a),1); Pos(3:4)=a(r).name;
end
IRDir=[IRDirB '/' Pos(3:4)];
%
nch=length(Mic);
IR=cell(nch,1);
for i=1:nch
  MatFN=[IRDir '/' Mic{i} '.mat'];  
  S=load(MatFN);
  IR{i}=S.risp_imp_save;  
end


%Generate
[N,D]=rat(IRFSamp/yFSamp);
y48=resample(y,N,D); %From yFSamp to 48k
[N2,D2]=rat(ysFSamp/IRFSamp);

%Convolve
yc48=conv(y48, IR{1});   a=resample(yc48,N2,D2); nsa=length(a); %Do first iter to obtain number of samples
ysa=zeros(nsa,nch); ysa(:,1)=a;
for i=2:nch
  fprintf('Convolution for Mic %s, pos %s .....', Mic{i}, Pos);  
  yc48=conv(y48, IR{i}); %the slowest function (filter(IR{i},1,y48) has the same speed)   
  fprintf('.... end\n');   
  ysa(:,i)=resample(yc48,N2,D2);  %From 48k to ysFSamp    
end

%Cut length, let a percentage of tail
ns=N2*length(y48)/D2;
a=ns+round(TailPer*(nsa-ns));  
ys=ysa(1:a,:); 


%Normalization of stereo to maximum of mono
%This manteins the relation energy along the channels because is normalized
%by the maximun
may=min(max(abs(y(:))),0.9999);
mays=max(abs(ys(:)));
ys=may*ys/mays;


% figure(1)
% subplot(111), plot(y), ylim([-1 1])
% 
% figure(2)
% subplot(511), plot(ys(:,1)), ylim([-1 1])
% subplot(512), plot(ys(:,2)), ylim([-1 1])
% subplot(513), plot(ys(:,3)), ylim([-1 1])
% subplot(514), plot(ys(:,4)), ylim([-1 1])
% subplot(515), plot(ys(:,5)), ylim([-1 1])
% pause
