function IntM=IntMKnownP(M,K,ClK)
%Interpolate Matrix from Known Points
%k: frames where is known the noise
%ClK: Closest K to do the mean (length of known elements for the mean)

if sum(K(:))==0
    fprintf('WARNING in IntMKnownP: there isnt any known pixels\n')
end


[nr, nc]=size(M);
n=1:nc; 
IntM=zeros(nr,nc);
for r=1:nr
    KR=K(r,:); MR=M(r,:); %known and matrix row
    k=n(KR); uk=n(~KR); %know and unknown elements
    kp=knnsearch(k',uk','k',ClK); ck=k(kp)'; %closest k   
    IntM(r,uk)=mean(MR(ck));    %interpolation by the mean
end
IntM(K)=M(K);


