function [M,V]=MeanF(X,hw)
%Mean Filter, along time of a matrix
%
%Outputs: mean and variance


[FL,nf]=size(X);
M=zeros(FL,nf); V=zeros(FL,nf);

%
Xt=X';

%Center
for i=1+hw:nf-hw; 
    a=Xt(i-hw:i+hw,:);       
    M(:,i)=mean(a);      
    V(:,i)=var(a); 
end


%Extremes
a=Xt(1:hw,:);
M(:,1:hw)=repmat(mean(a)',[1,hw]); 
V(:,1:hw)=repmat(var(a)',[1,hw]); 

a=Xt(nf-hw+1:nf,:); 
M(:,nf-hw+1:nf)=repmat(mean(a)',[1,hw]); 
V(:,nf-hw+1:nf)=repmat(var(a)',[1,hw]);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

