function [Val]=Key2ValDictA(Key,AKey,AVal,PrintError)
%Key To Valaue using a Dictionary for Array of numbers
%Key,Val: big arrays (input/output)
%AKey,AVal: vectors (dictionary)
%PrintError: 'e' 'w' 

if nargin<4
    PrintError='n';
end


%Since we usually have more Key than AKey (in text transcriptions) we do the loop for AKey
l=length(AKey);
Val=NaN(size(Key));
for i=1:l
    k=Key==AKey(i);
    Val(k)=AVal(i);
end
%
i=isnan(Val);
if sum(i)>0
    switch PrintError
        case 'e'
            error('Bad transcription: some Key are not in AKey')
        case 'w'
            warning('Bad transcription: some Key are not in AKey')
        otherwise
    end
end


