function [Val,k]=Key2ValDict(Key,AKey,AVal,PrintF)
%Key To Valaue using a Dictionary
%Key:a 1D cell i.e. a column vector of words or a sentence  Key={'Hello'    'I'    'go'    'home'    'this'}';
%AKey,AVal:  cell     
%
%It Works for any dictionary of cells (not only text)
%Key,AKey,AVal: must be cells. If they are numbers use Key2ValDictA
%
%For cell of matrix use Cell2M as in PhN2Ph


if nargin<4
    PrintF=1;
end


nak=length(AKey);
nk=length(Key);

%Since we usually have more Key than AKey (in text transcriptions) we do the loop for AKey
K=false(nk,nak);
for i=1:nak
    K(:,i)=strcmp(AKey{i},Key);
end





%Loop on Keys. In future try to do faster
k=zeros(size(Key));
n=1:nak;
for i=1:nk
    
    
    n2=n(K(i,:));
    s=length(n2);
    
    if s==1        
        k(i)=n2;        
        %fprintf('OK for %s\n',Key{i});
    elseif s>1    
        k(i)=n2(1);
        if PrintF; warning('Several Val for %s, used the first found %s',Key{i},AVal{k(i)}); end
        
    else
        k(i)=1;        
        if PrintF; warning('Not Val'); end
        
    end      
      
    

end

Val=AVal(k);

