function [M,in,en]=Cell2M(C)
%Cell of matrixes (or Cells) to one Matrix (or one cell)
%Assumming each cell element is a matrix (with fix (the same) row size), we concatenate
%all matrix along columns.
l=length(C);
in=zeros(1,l);
en=zeros(1,l);
ini=1;
for i=1:l    
    nf=size(C{i},2);    
    in(i)=ini;
    en(i)=ini+nf-1;    
    ini=ini+nf;       
end
nf=en(l);
FL=size(C{1},1);


if iscell(C{1})
    M=cell(1,nf);
    for i=1:l
        M(in(i):en(i))=C{i};
    end
    
else
    M=zeros(FL,nf);
    for i=1:l
        M(:,in(i):en(i))=C{i};
    end
end


