function retVal= StoreRoSpn(spn, filename)
%The storeSPN.m of Robert



%%% layer types
SUM = 1; PROD = 2; VAL = 3; IND = 4; GAUSS = 5; MIX = 6;

fid = fopen(filename, 'w');
if fid == -1
    error('error opening file');
end

fprintf(fid, 'SPN_NETWORK\n');
fprintf(fid, 'NumLayers: %d\n', spn.numLayers);

fprintf(fid, 'TYPES: ');
for k=1:spn.numLayers
    fprintf(fid, '%d ', spn.layerTypes(k));
end
fprintf(fid, '\n');
fprintf(fid, '\n');

for k=1:spn.numLayers
    fprintf(fid, 'LAYER %d: TYPE %d\n', k-1, spn.layerTypes(k));
    fprintf(fid, 'NumNodes: %d\n', spn.numNodes(k));
    
    switch spn.layerTypes(k)
        case VAL
            % do nothing
        case SUM
            for l = 1:spn.numNodes(k)
                fprintf(fid, '%d: ', size(spn.childIdx{k}{l}, 2));
                for m = 1:size(spn.childIdx{k}{l}, 2)
                    fprintf(fid, '%d %d', spn.childIdx{k}{l}(1,m)-1, spn.childIdx{k}{l}(2,m)-1);
                    fprintf(fid, ' %d', spn.weights{k}{l}(1,m));
                    if m < size(spn.childIdx{k}{l}, 2)
                        fprintf(fid, '|');
                    end
                end
                fprintf(fid, '\n');
            end
        case PROD
            for l = 1:spn.numNodes(k)
                fprintf(fid, '%d: ', size(spn.childIdx{k}{l}, 2));
                for m = 1:size(spn.childIdx{k}{l}, 2)
                    fprintf(fid, '%d %d', spn.childIdx{k}{l}(1,m)-1, spn.childIdx{k}{l}(2,m)-1);
                    if m < size(spn.childIdx{k}{l}, 2)
                        fprintf(fid, '|');
                    end
                end
                fprintf(fid, '\n');
            end
        case GAUSS
            for l = 1:spn.numNodes(k)
                fprintf(fid, '%d: ', size(spn.childIdx{k}{l}, 2));
                for m = 1:size(spn.childIdx{k}{l}, 2)
                    fprintf(fid, '%d %d', spn.childIdx{k}{l}(1,m)-1, spn.childIdx{k}{l}(2,m)-1);
                    fprintf(fid, ' %d %d', spn.means{k}{l}(1,m), spn.sigmas{k}{l}(1,m));
                    if m < size(spn.childIdx{k}{l}, 2)
                        fprintf(fid, '|');
                    end
                end
                fprintf(fid, '\n');
            end
        case IND
            for l = 1:spn.numNodes(k)
                fprintf(fid, '%d: ', size(spn.childIdx{k}{l}, 2));
                for m = 1:size(spn.childIdx{k}{l}, 2)
                    fprintf(fid, '%d %d', spn.childIdx{k}{l}(1,m)-1, spn.childIdx{k}{l}(2,m)-1);
                    fprintf(fid, ' %d', spn.indVals{k}{l}(1,m));
                    if m < size(spn.childIdx{k}{l}, 2)
                        fprintf(fid, '|');
                    end
                end
                fprintf(fid, '\n');
            end
        otherwise
            error(sprintf('unknown layer type %d', spn.layerTypes(k)));
    end
    fprintf(fid, '\n');
end

fclose(fid);
retVal = 1;
