function [FaIdx,FaLW,ChFaNoIdx,NFa]=Spn2FaIdxLW(Spn)
%Spn To Father in Index values

%
Idx=Spn.Idx; 
ChIdx=Spn.ChIdx;
TNNod=Spn.TNNod; %is equal to Idx(end,2)
LW=Spn.LW;

%Dictionary
L2MIdx=Li2MaIdxSpn(Idx,TNNod);

%Allocate memory for fathers
NLay=length(Idx);
FaIdx=cell(NLay,1); %Fathers
FaLW=cell(NLay,1);

for l=1:NLay   
    nn=Idx(l,2)-Idx(l,1)+1;
    FaIdx{l}=cell(1,nn);   
    FaLW{l}=cell(1,nn);
end


%Compute fathers
for l=1:NLay
    LaCh=ChIdx{l}; %Child of Layer
    nn=length(LaCh);
    IdxN=Idx(l,1):Idx(l,2);    
    
    for n=1:nn        
        %Node father
        FIdx=IdxN(n);    
           
        %Node children
        C=L2MIdx(LaCh{n},:); %Node children                  
        %Anotate father of every children
        nch=size(C,1);
        for k=1:nch    
            i=C(k,1);
            j=C(k,2);       
            FaIdx{i}{j}=[FaIdx{i}{j}; FIdx]; 
            FaLW{i}{j}=[FaLW{i}{j}; GetLW(LW,l,n,k)];
        end            
    end   
   
end

%Remove redundancies
for l=1:NLay
    LaCh=ChIdx{l}; %Child of Layer
    nn=length(LaCh);    
    for n=1:nn 
        [FaIdx{l}{n},FaLW{l}{n}]=UniqFa(FaIdx{l}{n},FaLW{l}{n});            
    end    
end



%Children of Fathers excluding current Node and compute Number of Fathers
NFa=cell(NLay,1);
for l=1:NLay
    LaCh=ChIdx{l}; %Child of Layer
    nn=length(LaCh);    
    ind=Idx(l,1):Idx(l,2);    
    NFa{l}=zeros(nn,1);
    
    
    for n=1:nn        
        Fa=FaIdx{l}{n};
        NFa{l}(n)=length(Fa);   %Number of Fathers     
        No=ind(n); %Current Node
        ChFaNoIdx{l}{n}=GetChFaNoIdx(No,Fa,L2MIdx,ChIdx);        
    end    

end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ChFaNo=GetChFaNoIdx(No,Fa,L2MIdx,ChIdx)
%Get Children of Fathers excluding current Node in Idx
%In/Out in Idx
%
Fam=L2MIdx(Fa,:);
NFa=size(Fam,1);
ChFaNoC=cell(1,NFa);
Le=zeros(NFa,1);
for k=1:NFa
    ChFa=ChIdx{Fam(k,1)}{Fam(k,2)};     %Children of a father. Always only 2 and one of them have to be the current n    
    ChFaNoC{k}=setdiff(ChFa,No); %Children of a father excluding current Node (must be a column) 
    Le(k)=length(ChFaNoC{k});
end


%Cell To Matrix
MaLe=max(Le);
ChFaNo=zeros(NFa,MaLe);
for k=1:NFa
    ChFaNo(k,1:Le(k))=ChFaNoC{k};    
end







function [FaIdx,FaLW]=UniqFa(FaIdxI,FaLWI)
%[C,ia,ic] = unique(A)
[FaIdx,ia,ic] = unique(FaIdxI);
if ~isempty(FaLWI)
    FaLW=FaLWI(ia);    
else
    FaLW=[];
end

function CLW=GetLW(LW,l,n,k)
%
LaLW=LW{l}; 
CLW=[];
if ~isempty(LaLW)
    LaNoLW=LaLW{n}; 
    if ~isempty(LaNoLW)
        CLW=LaNoLW(k);
    end
end

