function [Spn]=Ro2JuSpn(ModelMod)
%Robert (cpp) To Juan (matlab) Spn 
%Spn.Si (for Juan and Robert): is Std (not Var) 

%Read Robert
SpnI=LoadRoSpn(ModelMod);


%Convert Robert
NLay=SpnI.numLayers;
NNod=SpnI.numNodes;
Me=cell2mat(SpnI.means{2})';
Si=cell2mat(SpnI.sigmas{2})';
Ch=SpnI.childIdx; %Childrens
W=SpnI.weights;
%
TNNod=sum(NNod);
MaNNod=max(NNod);
II=zeros(NLay,MaNNod);
k=1;
Idx=zeros(NLay,2);
for i=1:NLay    
    a=zeros(1,NNod(i));
    for j=1:NNod(i)        
        a(j)=k;    
        k=k+1;  
        
      
    end
    II(i,1:NNod(i))=a;
    Idx(i,:)=[a(1) a(end)];
   
end

%
ChIdx=cell(NLay,1);
NCh=cell(NLay,1);
LW=cell(NLay,1);
for i=1:NLay     
    if ~isempty(Ch{i})
        nch=zeros(NNod(i),1);
        for j=1:NNod(i)           
            LInd=sub2ind([NLay,MaNNod], Ch{i}{j}(1,:), Ch{i}{j}(2,:));
            a=II(LInd);  
            nch(j)=length(a);
            ChIdx{i}{j}=a';   %Transpose now
            
            
            
        end   
        NCh{i}=nch;
        
    end
    
    if ~isempty(W{i})
        for j=1:NNod(i)
            LW{i}{j}=log(W{i}{j})'; %Transpose now, to avoid later
        end    
    end
end



Spn.Idx=Idx;
Spn.ChIdx=ChIdx;
Spn.Me=Me;
Spn.Si=Si;
Spn.LW=LW;
Spn.TNNod=TNNod;
Spn.NCh=NCh;





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
