function [TrPS,DevPS]=PrintSpnLosF(TrX,TrY,DevX,DevY,StModF,PrinTex,LosFK,LPrior)
%Print Spn  Loss Function (classification error in training) 
%StModF: Spn Structure or Mod File

if nargin<7
    LosFK='NPseLik';
    LPrior=[];
end



%
if isstruct(StModF)
    Spn=StModF;
else
    Spn=Ro2JuSpn(StModF);  
end


%
TrPS=LosFResSpn(TrX,TrY,Spn,LosFK,LPrior);
DevPS=LosFResSpn(DevX,DevY,Spn,LosFK,LPrior);
fprintf('\nValue of %s for Tr and Dev (%s) is: %.2f and %.2f\n',LosFK,PrinTex,TrPS,DevPS);  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Loss=LosFResSpn(X,Y,Spn,LosFK,LPrior)
%Loss Function Result for a Spn

%Reduce too many samples
nf=size(X,2);
MaNf=10000;
if nf>MaNf
    nf=MaNf;
    X=X(:,1:nf);
    Y=Y(:,1:nf);
    fprintf('WARNING: Reduced Tr number of samples to %d\n',MaNf)
end

%Log Likelihood
LL=Forw1Spn(X,-1,Spn,-1,'Spn');

%Compute Loss in clasification
[xx,Loss]=DLosFLogSpnO(LL,Y,LPrior,LosFK);






