function SC=NodeScope(Spn)
%


%
Idx=Spn.Idx; 
ChIdx=Spn.ChIdx;
Me=Spn.Me;
Si=Spn.Si;
LW=Spn.LW;
TNNod=Spn.TNNod; %is equal to Idx(end,2)
NCh=Spn.NCh;

%
%warning('Check the transpositions in Li2MaChIdx')
[Ch,L2MIdx]=Li2MaChIdx(TNNod,Idx,ChIdx);


%Scope
NLay=size(Idx,1);
SC=cell(NLay,1);
for la=2:NLay
    ChLa=Ch{la};
    nn=length(ChLa);    
    for n=1:nn
        SC{la}{n}=Scope1Node(Ch{la}{n},SC,la);
    end
end

%Check validity
for la=3:NLay   
    la
    ChLa=Ch{la};
    nn=length(ChLa);
    for n=1:nn
        Val=CheckVal1N(Ch{la}{n},SC,la);          
        if Val~=1
            warning('Node %d %d not valid',la,n)
            pause
        end        
    end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Val=CheckVal1N(Ch,SC,la)
%
SC1N=[];
NCh=size(Ch,1);
for c=1:NCh        
    a=SC{Ch(c,1)}{Ch(c,2)};
    SC1N{c}=a;    
end 
if mod(la,2)==0 %even, sum node
    Val=IsComplDecomp(SC1N,'c');    
else %odd, product node
    Val=IsComplDecomp(SC1N,'d');    
end




function t=IsComplDecomp(SC,k)
%
t=1;
NCh=length(SC);
for i=1:NCh
    SC1=SC{i}; lr=length(SC1);
    for j=i+1:NCh
        SC2=SC{j};           
        a=intersect(SC1,SC2);        
        l=length(a);          
        switch k            
            case 'c'
                if l~=lr; t=0; end 
                
            case 'd'
                if l~=0; t=0; end                 
        end        
    end
end






function SC1N=Scope1Node(Ch,SC,la)
%
SC1N=[];

if la>2   %Other layers 
    NCh=size(Ch,1);
    for c=1:NCh       
        
        a=SC{Ch(c,1)}{Ch(c,2)};
        SC1N=[SC1N a];    
    end    
    SC1N=unique(SC1N);
else    % First layer Scope
    SC1N=Ch(2);
end




