function spn = LoadRoSpn(filename)
%Rober To Matlab Spn (loadSPN.m of Robert)
%%% layer types
SUM = 1; PROD = 2; VAL = 3; IND = 4; GAUSS = 5; MIX = 6;


fid = fopen(filename);
if fid == -1
    error('invalid filename: %s',filename);
end

inputLine = fgetl(fid);
if ~strcmp(inputLine, 'SPN_NETWORK')
    error('invalid file');
end

%%% get number of layer
inputLine = fgetl(fid);
inputLine = inputLine(12:end);
numLayers = str2double(inputLine);
if isnan(numLayers)
    error('invalid file');
end
    
%%% get layer types
inputLine = fgetl(fid);
inputLine = inputLine(8:end);
layerTypes = str2num(inputLine);
if isempty(layerTypes)
    error('invalid file');
end

if length(layerTypes) ~= numLayers
    error('invalid file')
end

if any(layerTypes == MIX)
    error('sorry, currently not supporting mixed layers')
end

numNodes = zeros(1,numLayers);

for k = 1:numLayers
    %%% discard empty line and layer header, get number of nodes
    inputLine = fgetl(fid);
    inputLine = fgetl(fid);
    inputLine = fgetl(fid);
    inputLine = inputLine(11:end);
    
    curNumNodes = str2num(inputLine);
    if isnan(numLayers)
        error('invalid file');
    end
    numNodes(k) = curNumNodes;
        
    childIdx{k}  = [];
    %parentIdx{k} = [];
    weights{k}   = [];
    means{k}     = [];
    sigmas{k}    = [];
    indVals{k}   = [];
    if layerTypes(k) ~= VAL
        for l = 1:curNumNodes
            %%% get number of children
            inputLine = fgetl(fid);
            colonIdx = strfind(inputLine, ':');
            if length(colonIdx) ~= 1
                error('invalid file');
            end
            curNumChildren = str2double(inputLine(1:colonIdx-1));
            if isnan(curNumChildren)
                error('invalid file');
            end
            inputLine = inputLine(colonIdx+1:end);
            
            childIdx{k}{l} = [];
            if layerTypes(k) == SUM
                weights{k}{l} = [];
            end
            if layerTypes(k) == GAUSS
                means{k}{l} = [];
                sigmas{k}{l} = [];
            end
            if layerTypes(k) == IND
                indVals{k}{l} = [];
            end
            
            for m = 1:curNumChildren
                if m < curNumChildren
                    barIdx = strfind(inputLine, '|');
                    curString = inputLine(1:barIdx-1);
                    inputLine = inputLine(barIdx+1:end);
                else
                    curString = inputLine;
                end
                
                curNum = str2num(curString);
                childIdx{k}{l} = [childIdx{k}{l}, curNum(1:2)'+1];
                
                if layerTypes(k) == SUM
                    weights{k}{l} = [weights{k}{l}, curNum(3)];
                end
                if layerTypes(k) == GAUSS
                    means{k}{l}  = [means{k}{l}, curNum(3)];
                    sigmas{k}{l} = [sigmas{k}{l}, curNum(4)];
                end
                if layerTypes(k) == IND
                    indVals{k}{l} = [indVals{k}{l}, curNum(3)];
                end
            end
        end
    end
end

fclose(fid);

spn.numLayers  = numLayers;
spn.layerTypes = layerTypes;
spn.numNodes   = numNodes;
spn.childIdx   = childIdx;
spn.weights    = weights;
spn.means      = means;
spn.sigmas     = sigmas;
spn.indVals    = indVals;

