function Ju2RoSpn(ModelMod,Spn)
%Juan To Robert Spn
%

%      numLayers: 80
%     layerTypes: [1x80 double]
%       numNodes: [1x80 double]
%       childIdx: {1x80 cell}
%        weights: {1x80 cell}
%          means: {1x80 cell}
%         sigmas: {1x80 cell}
%        indVals: {1x80 cell}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       Idx: [80x2 double]
%     ChIdx: {80x1 cell}
%        Me: [399x1 double]
%        Si: [399x1 double]
%        LW: {80x1 cell}
%     TNNod: 10419
%       NCh: {80x1 cell}

%
Idx=Spn.Idx; 
ChIdx=Spn.ChIdx;
Me=Spn.Me;
Si=Spn.Si;
LW=Spn.LW;
TNNod=Spn.TNNod; %is equal to Idx(end,2)
NCh=Spn.NCh;

%
[Ch,L2MIdx]=Li2MaChIdx(TNNod,Idx,ChIdx);


RSpn.childIdx=Ju2RoCh(Ch);



%numLayers and others
[RSpn.numLayers,RSpn.numNodes,RSpn.layerTypes,RSpn.indVals,RSpn.means,RSpn.sigmas]=Ju2RoNLay(Idx,ChIdx,Me,Si);

%weights
RSpn.weights=Ju2RoW(LW);


%
StoreRoSpn(RSpn,ModelMod);
fprintf('Written: %s\n',ModelMod);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function childIdx=Ju2RoCh(Ch)
%
l=length(Ch);
childIdx=cell(1,l);
for i=1:l
    m=length(Ch{i});
    for j=1:m
        childIdx{i}{j}=(Ch{i}{j})';
    end   
end




function [numLayers,numNodes,layerTypes,indVals,means,sigmas]=Ju2RoNLay(Idx,ChIdx,Me,Si)
%
numLayers=size(Idx,1);
numNodes=zeros(1,numLayers);
layerTypes=zeros(1,numLayers); 
indVals=cell(1,numLayers);
%
layerTypes(1)=3;        layerTypes(2)=5;
numNodes(1)=Idx(1,2);   numNodes(2)=length(ChIdx{2});
for l=3:numLayers
    numNodes(l)=length(ChIdx{l});
    layerTypes(l)=mod(l,2)+1;
end
%means & sigmas
means=cell(1,numLayers); means{2}=num2cell(Me)';
sigmas=cell(1,numLayers); sigmas{2}=num2cell(Si)';



function TC=Ju2RoW(LW)
%Basically: exp and row conversion
l=length(LW);
TC=cell(1,l);
for i=1:l
    m=length(LW{i});
    for j=1:m
        TC{i}{j}=exp(LW{i}{j})';
    end   
end

