function Spn=Gmm2Spn1(Gmm)
%Gmm2Spn of only 1 Gmm in Kaldi-Matlab format
%Spn: Juan format: Me, Si, LW, ChIdx, NCh, Idx, TNNod
%Gmm: Kaldi format
%Spn.Si: Std (not Var)


%Mean and Sigmas. We reorder to have in order: 1)x(1) gaus, 2)x(2) gaus, ...
a=sqrt(1./Gmm.Inv_vars); b=a'; Si=b(:);
a=Gmm.Means_invvars./Gmm.Inv_vars;    b=a'; Me=b(:);
a=log(Gmm.Weights);  LW{4}{1}=a';

%II
[FL,NG]=size(Gmm.Inv_vars); %FL and Number of multivariate Gaussians
NUG=FL*NG; %Number of Univariate Gaussians

II{1}=1:FL;
II{2}=(FL+1:FL+NUG)'; %I should transpose all, but only this to avoid problem when NG=1
II{3}=FL+NUG+1:FL+NUG+NG;
II{4}=FL+NUG+NG+1;

%Idx
Idx(1,:)=[II{1}(1) II{1}(end)];
Idx(2,:)=[II{2}(1) II{2}(end)];
Idx(3,:)=[II{3}(1) II{3}(end)];
Idx(4,:)=[II{4}(1) II{4}(end)];
TNNod=Idx(4,2);


%Childrens
ChIdx{1}={};

idx=repmat((1:FL)',[1,NG]); %refer to Inv_vars
a=idx'; c=a(:); %childrens (of previoys layer, not indexed)
m=II{1}(c);
ChIdx{2}=num2cell(m');


c=repmat((1:NG:NUG)',[1,NG])+repmat((0:NG-1),[FL,1]); %c: 40*2 (40*1)
a=II{2}; %1*80 (1*40)
m=a(c); %m:80*2 (1*40)
ChIdx{3}=mat2cell(m,FL,ones(1,NG));
c=1:NG;
m=II{3}(c);
ChIdx{4}={m};


%NCh
NCh{1}=0;
NCh{2}=ones(1,NUG);
NCh{3}=FL*ones(1,NG);
NCh{4}=NG;


%
Spn.Me=Me;
Spn.Si=Si;
Spn.LW=LW;
Spn.ChIdx=ChIdx;
Spn.NCh=NCh;
Spn.Idx=Idx;
Spn.TNNod=TNNod;
