function SpnDiscrTr(modelFile2,modelFile,TrCl,TrX,TrY,DevX,DevY,LosFK,Info,P)
%Spn Discriminative Training of weigths, means and sigmas
%



%
TrNS=size(TrX,2); DevNS=size(DevX,2);
fprintf('Tr and Dev: %d and %d samples\n',TrNS,DevNS);

%
LPrior=LogPriors(TrY);
    
%Param
UpP1    = 0.95; %ro
UpP2    = 1e-6; %eps
NEpoch= P.ExOpt.numIterEM; %around 20
%TrBL     = 300; %Training Batch Length
TrBL     =4000; %around 3 times the number of output

[pn,bn,ext]=fileparts(modelFile);
[pn2]=fileparts(pn);
switch P.TrOpt1
    case 0
        a='SpnMod_SpnMultO_NoMvn';
    case 1
        a='SpnMod_SpnMultO_EM_NoMvn';
end
modelFile=[pn2 '/' a '/' bn ext]


%Number of batches
DevBL=round((DevNS/TrNS)*TrBL);
NB=TrDevBatchI(TrX,TrY,DevX,DevY,TrBL,DevBL,-1);

%Read starting Spn
SpnMatF=RoMod2JuMatSpnFN(modelFile,TrCl);
S=load(SpnMatF); Spn=S.Spn; 
Spn.LayK=SpnLayerKind(Spn); %FUTURE models will have LayK, so remove in future

%Tmp: to save each epoch Spn
[SpnMatF2,SpnMatDir2,BN2]=RoMod2JuMatSpnFN(modelFile2,TrCl); 
EpDir=[SpnMatDir2 '/EpDir']; [x,x,x]=rmdir(EpDir,'s'); [x,x,x]=mkdir(EpDir);

%Ini Parameter Vectors resued every batch iteration
WeV.P1=LWNetFun(Spn.LW,'zeros'); WeV.P2=LWNetFun(Spn.LW,'zeros');  WeV.P3=LWNetFun(Spn.LW,'zeros');
MeV.P1=zeros(size(Spn.Me)); MeV.P2=zeros(size(Spn.Me)); MeV.P3=zeros(size(Spn.Me));
SiV.P1=zeros(size(Spn.Si)); SiV.P2=zeros(size(Spn.Si)); SiV.P3=zeros(size(Spn.Si));

%Print ini Losormance
Los.Tr=zeros(1,NEpoch); Los.Dev=zeros(1,NEpoch);
[Los.Tr(1),Los.Dev(1)]=PrintSpnLosF(TrX,TrY,DevX,DevY,Spn,['epoch' num2str(0)],LosFK,LPrior); 
Los.BDev=Los.Dev(1); Los.BTr=Los.Tr(1); BSpn=Spn;

%
for e=2:NEpoch %start in 2 because the 1 is the initial
    tic       
    fprintf('Discrim Tr: UpP1=%d, UpP2=%d, LosFK=%s, NEpoch=%d, TrBL=%d, NB=%d\n',UpP1,UpP2,LosFK,NEpoch,TrBL,NB) 
    for b=1:NB   
        fprintf('%d ',b), if mod(b,30)==0; fprintf('\n'); end
        %Batch
        [BTrX,BTrY]=TrDevBatchI(TrX,TrY,DevX,DevY,TrBL,DevBL,b);
        %Derivatives
        [DW,DMe,DSi]=DLosFSpn(BTrX,BTrY,Spn,LPrior,LosFK);     
        %Updates        
        [Spn.LW,WeV,Spn.Me,MeV,Spn.Si,SiV]=UpdateWeMeSi(Spn.LW,DW,WeV,Spn.Me,DMe,MeV,Spn.Si,DSi,SiV,UpP1,UpP2,P.ExOpt.UpWeMeSi);               
    end
    
    %    
    [Los.Tr(e),Los.Dev(e)]=PrintSpnLosF(TrX,TrY,DevX,DevY,Spn,['epoch' num2str(e)],LosFK,LPrior);
    
    %Save Epoch Spn 
    [Los,BSpn]=SavSpnEpBest(EpDir,BN2,Spn,Info,BSpn,Los,e);       
    toc
    
end

%Save the best and Plot
Spn=BSpn; Info.Los=Los;
save(SpnMatF2,'Spn','Info');  
Ju2RoSpn(modelFile2,Spn);

Los.Tr
Los.Dev

%plot(Los.Tr), hold on, plot(Los.Dev,'r'), hold off, legend('Los.Tr','Los.Dev')





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [LW,WeV,Me,MeV,Si,SiV]=UpdateWeMeSi(LWI,DW,WeVI,MeI,DMe,MeVI,SiI,DSi,SiVI,UpP1,UpP2,UpWeMeSi)
%
LW=LWI; Me=MeI;   Si=SiI;
WeV=WeVI; MeV=MeVI; SiV=SiVI;


if UpWeMeSi(1)
    [LW,WeV]=LWNetFun(LWI,'update',DW,UpP1,UpP2,WeVI); %mean(abs(DW))=3.6895e-04
  
    
end
if UpWeMeSi(2)
    MeMin=-3; MeMax=+3; %min(Spn.Me)=-2.2200; max(Spn.Me)=2.2352;  
    [Me,MeV.P1,MeV.P2,MeV.P3]=SGDUpdate(MeI,UpP1,UpP2,DMe,MeVI.P1,MeVI.P2,MeVI.P3);    %mean(abs(DMe))=4.8023e-22    
    Me(Me<MeMin)=MeMin;
    Me(Me>MeMax)=MeMax;        
end
if UpWeMeSi(3)
    SiMin=0.01; SiMax=3; %min(Spn.Si)=1; max(Spn.Si)=1;    
    [Si,SiV.P1,SiV.P2,SiV.P3]=SGDUpdate(SiI,UpP1,UpP2,DSi,SiVI.P1,SiVI.P2,SiVI.P3); %mean(abs(DSi))=8.4414e-22    
    Si(Si<SiMin)=SiMin; 
    Si(Si>SiMax)=SiMax;      
end





