function [PseudoLL]=SpnDir2LogLikUnc(Y,U,MF,SpnMatDir,NPdf,UnK,P)
%Spn Dir To Log Likelihood (LL) Uncertainty
%PseudoLL:  Pseudo Log Likel
%Y:         FeatureGram matrix (row feature, column time)
%U:         Uncertaing matrix
%MF:        Minimum Floor for Uncertainty
%NPdf:      Number of Pdfs


%All Spns .mat inside of SpnMatDir
[MatL]=LsBn12Ext(SpnMatDir,'Spn','*','mat');
NSpn=length(MatL);

%Allocate
[FL,nf]=size(Y);
PseudoLL=log(zeros(NPdf,nf));
tt=0; %total time
tns=0; %total number of samples

fprintf('Spn Mat: %s\n',SpnMatDir);
fprintf('Spn propagation: %s. Of %d: \n',UnK,NSpn);

%Loop for all Spns of directory SpnMatDir
for i=1:NSpn
%for i=60   
    tic
  
    %Read Spn and its Info from .mat    
    S=load([MatL{i}]); Spn=S.Spn; Info=S.Info;     
              
    
    %MAIN FUNCTION: Juan inference     
    LL=Forw1Spn(Y,U,Spn,MF,UnK,P);                 

  
% %     %Robert inference (to compare)
%      [pn,bn]=fileparts(MatL{i});   SpnModDir=[pn '/' bn];
%      LL2=inferLL(Y', [], 'modelFile', [SpnModDir '/' bn '.mod'], 'binPath', [SpnBinDir '/']); LL2=LL2';   
%      subplot(111), plot(LL), hold on, plot(LL2,'ro'),  hold off,    pause        
    
      
    %Fill corresponding channel of PseudoLL    
    PseudoLL(Info.LabOutDict(1,:)+1,:)=LL;     
    
    
    %Average time 
    tt=tt+toc; fprintf('%d(%.2f),',i,(tt/i)); if mod(i,10)==0; fprintf('\n'); end 
    tns=tns+Info.NS.ptr;    
    
end


      





