function data = readSPNDataText(filename)

fid = fopen(filename);

inputLine = fgetl(fid);
if ~strcmp(inputLine, 'SPN_DATA:txt')
    error('first line has to be ''SPN_DATA:txt''')
end

inputLine = fgetl(fid);
numDims = str2double(inputLine);
if isnan(numDims)
    error('malformatted file')
end

inputLine = fgetl(fid);
numSamples = str2double(inputLine);
if isnan(numSamples)
    error('malformatted file')
end

data = zeros(numSamples, numDims);

for k=1:numSamples
    inputLine = fgetl(fid);
    curSample = str2num(inputLine);
    if length(curSample) ~= numDims
        error('malformatted file')
    end
    data(k,:) = curSample;
end

fclose(fid);


