function AN=NormFeUn(A,GParDir,k1,k2,k3)
%Normalize Features or Uncertainty 
%k1: feat, unc
%k2: ClGIMvn
%k3: Tr12




switch k1   
    case 'feat'          
         
        switch k2           
                
             case 'IMvn' %Clean Individual
                S=load([GParDir '/TrGPar.mat']);                                                 
                i=strcmp(k3,S.I.ModBN); Me2=S.I.Me(:,i); Std2=S.I.Std(:,i);
                %Me=mean(A,2) should be equal or similar to Me2                 
                AN=MeStdNorm(A,Me2,Std2);       
             
          case 'NoMvn' %No Mvn
                AN=A; 
                
            case 'GMvn' %Clean Global
                S=load([GParDir '/TrGPar.mat']);   
                Me=S.Me; Std=S.Std;
                AN=MeStdNorm(A,Me,Std);  
                
            case 'GHEq'
                S=load([GParDir '/TrGPar.mat']);                
                AN=ChHistEq(A,S.HEX,S.HEY);                  

        end



    case 'unc'  
        %Is Equivalent to
        %FeY=NormFeUn(P.Tmp.Y,Me,Std,'feat');
        %FeX=NormFeUn(P.Tmp.X,Me,Std,'feat');     
        %Un2=(FeY-FeX).^2;

        nf=size(A,2);
        InvStd2=(1./Std).^2;
        AN=A.*repmat(InvStd2,[1,nf]);        
end

% subplot(211), jimagesc(A), 
% subplot(212), jimagesc(AN),
% pause









