function [LL, R] = viterbi(Data, spn, varargin)

params = {'modelFile', 'binPath', 'dataFile', 'upwardsPass', 'useCorrectionWeights'};

if mod(length(varargin), 2) ~= 0
    error('varargin must contain even number of entries')
end

for k = 1:length(params)
    eval(sprintf('%s = [];', params{k}));
end

k = 1;
while k < length(varargin)
    foundmatch = 0;
    for p = 1:length(params)
        if strcmpi(params{p}, varargin{k})
            eval(sprintf('%s = varargin{k+1};', params{p}));
            foundmatch = 1;
            k = k + 1;
        end
    end
    if foundmatch == 0
        error('unknown parameter %s', varargin{k})
    end
    k = k + 1;
end

tmpFile = tempname();

if isempty(dataFile)    
    tmpDataFile = [tmpFile, '_data'];
    writeSPNVecList(tmpDataFile, Data);
else
    tmpDataFile = dataFile;
end

if isempty(modelFile)
    tmpModelFile = [tmpFile, '_model'];
    storeSPN(spn, tmpModelFile);
else
    tmpModelFile = modelFile;
end

tmpOutputFile = [tmpFile, '_out'];

cmd = sprintf('"%s/viterbi" %s %s outputfile = %s', binPath, tmpModelFile, tmpDataFile, tmpOutputFile);

if ~isempty(upwardsPass)
    cmd = [cmd, sprintf(' upwardsPass = %s', upwardsPass)];
end

if ~isempty(useCorrectionWeights)
    cmd = [cmd, sprintf(' useCorrectionWeights = %d', useCorrectionWeights)];
end

%%%%
%%%%
%disp(cmd)
sysStat = system(cmd, '-echo');
%%%%
%%%%

if sysStat == 0
    OutputData = readSPNDataText(tmpOutputFile);
    LL = OutputData(:,1);
    R = OutputData(:,2:end);
end

if isempty(dataFile)
    delete(tmpDataFile);
end

if isempty(modelFile)
    delete(tmpModelFile);
end

delete(tmpOutputFile)

if (sysStat ~= 0)
    disp(sysRes)
    error('failed to perform inference')
end
