clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
SPN_Path = '~/RobustASR/';
Bin_Path = '../CPP/bin/';
Model_Path = '../Models/';
addpath([SPN_Path, 'Matlab/libspn']);
load('TrDev');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
label = 7;

%%%
numGauss = 10;
numSums = 20;
batchSize = 10;
sparsePrior = 1;
sparsePriorAnneal = 10;

%%%
coarseRes = [4];
coarseResX = [];
coarseResY = [];

%%%
numIter = 20;
earlyStoppingKrel = 3;
earlyStoppingKabs = 5;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

trainData = Tr.Feat(:,Tr.Post == label);
valData = Dev.Feat(:,Dev.Post == label);

if isempty(trainData)
    error('No training data for label %d', label);
end
if isempty(valData)
    error('No validation data for label %d', label);
end

modelFile = sprintf('%sSPN%d_G%d_S%d_B%d_sP%d.mod', Model_Path, label, numGauss, numSums, batchSize, sparsePrior);

trainSPN_PD(trainData', 40, 11, ...
    'valData', valData', ...
    'binPath', Bin_Path,...
    'numGauss', numGauss, ...
    'numIter', numIter, ...
    'modelFile', modelFile,...
    'stop_absLikelihoodChange', -1e20,...    
    'earlyStoppingKrel', earlyStoppingKrel,...
    'earlyStoppingKabs', earlyStoppingKabs,...
    'coarseRes', coarseRes, ...
    'coarseResX', coarseResX, ...
    'coarseResY', coarseResY, ...
    'batchSize', batchSize);

LLtrain = inferLL(trainData', [], 'modelFile', modelFile, 'binPath', Bin_Path);
LLval = inferLL(valData', [], 'modelFile', modelFile, 'binPath', Bin_Path);

fprintf('LL train: %d   LL val: %d\n', sum(LLtrain), sum(LLval));
