function success = trainSPN_PD(Data, dimX, dimY, varargin)

success = false;

%%%%%%%%%%%%%%
%%% params %%%
%%%%%%%%%%%%%%

coarseRes  = [];
coarseResX = [];
coarseResY = [];
batchSize  = [];
numSums    = [];
numGauss   = [];
gaussMeansFile = '';
numIter    = [];
stop_absLikelihoodChange = [];
stop_relLikelihoodChange = [];
earlyStoppingKrel = [];
earlyStoppingKabs = [];
sparsePrior       = [];
sparsePriorAnneal = [];
preSubtractCounts = [];
flatEM            = [];
numChannels       = [];
pixelOrder        = [];
modelFile         = [];
trainDataFile     = [];
valDataFile       = [];
binPath           = '';
valData           = [];

k = 1;
while k < length(varargin)
    switch varargin{k}
        case 'coarseRes'
            coarseRes = varargin{k+1};
            k = k+1;
        case 'coarseResX'
            coarseResX = varargin{k+1};
            k = k+1;
        case 'coarseResY'
            coarseResY = varargin{k+1};
            k = k+1;
        case 'batchSize'
            batchSize = varargin{k+1};
            k = k+1;
        case 'numSums'
            numSums = varargin{k+1};
            k = k+1;
        case 'numGauss'
            numGauss = varargin{k+1};
            k = k+1;
        case 'gaussMeansFile'
            gaussMeansFile = varargin{k+1};
            k = k+1;
        case 'numIter'
            numIter = varargin{k+1};
            k = k+1;
        case 'stop_absLikelihoodChange'
            stop_absLikelihoodChange = varargin{k+1};
            k = k+1;
        case 'stop_relLikelihoodChange'
            stop_relLikelihoodChange = varargin{k+1};
            k = k+1;
        case 'earlyStoppingKrel'
            earlyStoppingKrel = varargin{k+1};
            k = k+1;     
        case 'earlyStoppingKabs'
            earlyStoppingKabs = varargin{k+1};
            k = k+1;    
        case 'sparsePrior'
            sparsePrior = varargin{k+1};
            k = k+1;
        case 'sparsePriorAnneal'
            sparsePriorAnneal = varargin{k+1};
            k = k+1;
        case 'preSubtractCounts'
            preSubtractCounts = varargin{k+1};
            k = k+1;
        case 'flatEM'
            flatEM = varargin{k+1};
            k = k+1;
        case 'numChannels'
            numChannels = varargin{k+1};
            k = k+1;
        case 'pixelOrder'
            pixelOrder = varargin{k+1};
            k = k+1;
        case 'modelFile'
            modelFile = varargin{k+1};
            k = k+1;
        case 'trainDataFile'
            trainDataFile = varargin{k+1};
            k = k+1;
        case 'valDataFile'
            valDataFile = varargin{k+1};
            k = k+1;
        case 'binPath'
            binPath = varargin{k+1};
            k = k+1;
        case 'valData'
            valData = varargin{k+1};
            k = k+1;
        otherwise
            disp(varargin{k})
            error('unknown parameter')
    end
    k = k + 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if dimX * dimY ~= size(Data,2) && isempty(trainDataFile)
    error('dimX * dimY ~= size(Data,2)')
end

if ~isempty(valData) && isempty(valDataFile)
    if size(Data,2) ~= size(valData,2)
        error('size(Data,2) ~= size(valData,2)')
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tmpFile = tempname;

if isempty(trainDataFile)
    tmpTrainFile = [tmpFile, '_trainSPN_PD'];
    writeSPNVecList(tmpTrainFile, Data);
else
    tmpTrainFile = trainDataFile;
end

if isempty(modelFile)
    tmpModelFile = [tmpFile, '_model'];
else
    tmpModelFile = modelFile;
end

% cmd = sprintf('"./%strainPD" %s %s width = %d height = %d',...
%     binPath, tmpTrainFile, tmpModelFile, dimX, dimY);

cmd = sprintf('"%strainPD" %s %s width = %d height = %d',...
    binPath, tmpTrainFile, tmpModelFile, dimX, dimY);

if isempty(valDataFile)
    if ~isempty(valData)
        tmpValFile = [tmpFile, '_valSPN_PD'];
        writeSPNVecList(tmpValFile, valData);
        cmd = [cmd, sprintf(' valDataFile = %s', tmpValFile)];
    end
else
    tmpValFile = valDataFile;
    cmd = [cmd, sprintf(' valDataFile = %s', tmpValFile)];
end

if ~isempty(coarseRes)
    if length(coarseRes) == 1
        coarseStr = ['[', sprintf('%d', coarseRes(end)), ']'];
    else
        coarseStr = ['[', sprintf('%d,',coarseRes(1:end-1)), sprintf('%d', coarseRes(end)), ']'];
    end
    cmd = [cmd, sprintf(' coarseRes  = %s', coarseStr)];
end

if ~isempty(coarseResX)
    if length(coarseResX) == 1
        coarseStr = ['[', sprintf('%d', coarseResX(end)), ']'];
    else
        coarseStr = ['[', sprintf('%d,',coarseResX(1:end-1)), sprintf('%d', coarseResX(end)), ']'];
    end
    cmd = [cmd, sprintf(' coarseResX = %s', coarseStr)];
end

if ~isempty(coarseResY)
    if length(coarseResY) == 1
        coarseStr = ['[', sprintf('%d', coarseResY(end)), ']'];
    else
        coarseStr = ['[', sprintf('%d,',coarseResY(1:end-1)), sprintf('%d', coarseResY(end)), ']'];
    end
    cmd = [cmd, sprintf(' coarseResY = %s', coarseStr)];
end

if ~isempty(batchSize)
    cmd = [cmd, sprintf(' batchSize = %d', batchSize)];
end

if ~isempty(numSums)
    cmd = [cmd, sprintf(' numSums = %d', numSums)];
end

if ~isempty(numGauss)
    cmd = [cmd, sprintf(' numGauss = %d', numGauss)];
end

if ~isempty(gaussMeansFile)
    cmd = [cmd, sprintf(' gaussMeansFile = %s', gaussMeansFile)];
end

if ~isempty(numIter)
    cmd = [cmd, sprintf(' numIter = %d', numIter)];
end

if ~isempty(stop_absLikelihoodChange)
    cmd = [cmd, sprintf(' stop_absLikelihoodChange = %d', stop_absLikelihoodChange)];
end

if ~isempty(stop_relLikelihoodChange)
    cmd = [cmd, sprintf(' stop_relLikelihoodChange = %d', stop_relLikelihoodChange)];
end

if ~isempty(earlyStoppingKrel)
    cmd = [cmd, sprintf(' earlyStoppingKrel = %d', earlyStoppingKrel)];
end

if ~isempty(earlyStoppingKabs)
    cmd = [cmd, sprintf(' earlyStoppingKabs = %d', earlyStoppingKabs)];
end

if ~isempty(sparsePrior)
    cmd = [cmd, sprintf(' sparsePrior = %d', sparsePrior)];
end

if ~isempty(sparsePriorAnneal)
    cmd = [cmd, sprintf(' sparsePriorAnneal = %d', sparsePriorAnneal)];
end

if ~isempty(preSubtractCounts)
    cmd = [cmd, sprintf(' preSubtractCounts = %d', preSubtractCounts)];
end

if ~isempty(flatEM)
    cmd = [cmd, sprintf(' flatEM = %d', flatEM)];
end

if ~isempty(numChannels)
    cmd = [cmd, sprintf(' numChannels = %d', numChannels)];
end

if ~isempty(pixelOrder)
    cmd = [cmd, sprintf(' pixelOrder = %s', pixelOrder)];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[sysStat, sysRes] = system(cmd, '-echo');

if isempty(trainDataFile)
    delete(tmpTrainFile);
end

if isempty(valDataFile) && ~isempty(valData)
    delete(tmpValFile);
end

if isempty(modelFile)
    delete(tmpModelFile)
end

if (sysStat ~= 0)
    error('failed to train SPN')
end

success = true;

