function MPEData = inferMPE_PD(Data, spn, modelFile, binPath)

if nargin < 3 
    modelFile = [];
end

if nargin < 4
    binPath = '';
end

tmpFile = tempname;

tmpDataFile = [tmpFile, '_data'];
writeSPNVecList(tmpDataFile, Data);

if isempty(modelFile)
    tmpModelFile = [tmpFile, '_model'];
    storeSPN(spn, tmpModelFile);
else
    tmpModelFile = modelFile;
end

tmpOutputFile = [tmpFile, '_out'];

cmd = sprintf('"%sinferMPE_PD" %s %s > %s', binPath, tmpModelFile, tmpDataFile, tmpOutputFile);
%cmd = sprintf('"%sinferMPE_PD" %s %s', binPath, tmpModelFile, tmpDataFile);
[sysStat, sysRes] = system(cmd);

if sysStat == 0
    MPEData = readSPNDataText(tmpOutputFile);
end

delete(tmpDataFile);
if isempty(modelFile)
    delete(tmpModelFile);
end
delete(tmpOutputFile)

if (sysStat ~= 0)
    disp(sysRes)
    error('failed to perform inference')
end


