function OutputData = inferLL(Data, spn, varargin)

params = {'modelFile', 'binPath', 'dataFile'};

if mod(length(varargin), 2) ~= 0
    error('varargin must contain even number of entries')
end

for k = 1:length(params)
    eval(sprintf('%s = [];', params{k}));
end

k = 1;
while k < length(varargin)
    foundmatch = 0;
    for p = 1:length(params)
        if strcmpi(params{p}, varargin{k})
            eval(sprintf('%s = varargin{k+1};', params{p}));
            foundmatch = 1;
            k = k + 1;
        end
    end
    if foundmatch == 0
        error('unknown parameter')
    end
    k = k + 1;
end

tmpFile = tempname();

if isempty(dataFile)    
    tmpDataFile = [tmpFile, '_data'];
    writeSPNVecList(tmpDataFile, Data);
else
    tmpDataFile = dataFile;
end

if isempty(modelFile)
    tmpModelFile = [tmpFile, '_model'];
    storeSPN(spn, tmpModelFile);
else
    tmpModelFile = modelFile;
end

tmpOutputFile = [tmpFile, '_out'];

cmd = sprintf('"%s/inferLL" %s %s > %s', binPath, tmpModelFile, tmpDataFile, tmpOutputFile);
[sysStat, sysRes] = system(cmd);

if sysStat == 0
    OutputData = readSPNDataText(tmpOutputFile);
end

if isempty(dataFile)
    delete(tmpDataFile);
end

if isempty(modelFile)
    delete(tmpModelFile);
end

delete(tmpOutputFile)

if (sysStat ~= 0)
    disp(sysRes)
    error('failed to perform inference')
end
