function LPrior=LogPriors(TrY)
%Compute Log Priors
% TrY=[0,1...NLab-1];
%LPrior=ReKaldPriors([HmmDir '/ali_train_pdf.counts']); % Path to prior Info 

UY=unique(TrY);
NUY=length(UY);
LPrior=zeros(NUY,1);
ns=length(TrY); %total number of samples
for i=0:NUY-1
    c=sum(TrY==i);
    if c==0
        warning('No samples for label %d',i);
    end
    LPrior(i+1)=log(c/ns);
end