function [LW,WV]=LWNetFun(LWI,k,DW,Nabla,Moment,WVI)
%Log Weigth Network Functions
%LW: can be a Network (for update, zeros,...) or a scalar (for min, mean..)

LW=LWI;
WV=[];
NLay=length(LWI);


switch k
   
    case 'update'    
        WV=WVI;  
        wmi=0.01; %checked with LWMin=LWNetFun(Spn.LW,'min'); % exp(LWMin)=exp(-4.5130)=0.0110
        wma=10; %after normalization will be one       
        for l=1:NLay
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod   
                    %update                    
                    [w,WV.P1{l}{n},WV.P2{l}{n},WV.P3{l}{n}]=SGDUpdate(exp(LWI{l}{n}),Nabla,Moment,DW{l}{n},WVI.P1{l}{n},WVI.P2{l}{n},WVI.P3{l}{n}); 
                    %first norm
                    w=w/sum(w);  
                    %second norm
                    w(w<wmi)=wmi;
                    w(w>wma)=wma;
                    LW{l}{n}=log(w/sum(w)); %normalize wo before log                  
                end
            end
        end
    
        
        
    case 'rand'
        for l=1:NLay
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod
                    nw=length(LWI{l}{n});
                    a=rand(nw,1); a=a/sum(a);                    
                    LW{l}{n}=log(a);                
                end
            end
        end
    
  
    case 'zeros'
        for l=1:NLay
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod                        
                    LW{l}{n}=zeros(size(LWI{l}{n}));                       
                end
            end
        end
        
    

        
    case 'exp'        
        for l=1:NLay
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod
                    LW{l}{n}=exp(LWI{l}{n});
                end
            end
        end
   
        
    case 'min'
        mi=Inf;        
        for l=1:NLay
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod                        
                    mi=min(mi,min(LW{l}{n}));                       
                end
            end
        end     
        LW=mi;
        
        
    case 'LayMean'  
        LW=zeros(1,NLay);
        for l=1:NLay
            c=0; s=0;            
            if ~isempty(LWI{l})
                NNod=length(LWI{l});
                for n=1:NNod
                    a=(LWI{l}{n});
                    s=s+sum(a); c=c+length(a);
                end
            end
            LW(l)=s/c;            
        end
        
        
        
end