function Ju2RoSpnEmTr(EMmodelFile,modelFile,XTr,YTr,XDev,YDev,SpnBinDir,P)
%Expectation Maximization (valid for multioutput SPN)
% Tr and Dev: 1985 and 1985 samples 
%(update weight): 262.833933 seconds.
%update me and std: 283.652505
%update all: 286.035276 seconds.
%Tr and Dev: 7940 and 5955 samples 986.913487 seconds. (16.4 min)
% Tr and Dev: 297693 and 59539 samples (more than 16 hours, not finish, due to iterations)
% Tr and Dev: 24000 and 7200 samples (7.2755 hours) Tr and Dev (EM): -48.73 and -50.90 Tr and Dev (NoEM): -55.06 and -56.51
%Tr and Dev: 7940 and 2382 samples (23x2) 1153.989371 seconds.
%-------------------------------------------------------------
%Tr and Dev (40x1Fmllr,MultO132): 100000 and 30000 samples, 115715.884875 (32h) seconds.


Bin_Path = [SpnBinDir '/'];

% EM learning
%
% numIterEM: number of iterations
% earlyStoppingK_EM: early stopping parameter
% updateWeights: update sum weights?
% updateMeans: update means?
% updateSigmas: update sigmas?
% minSigma: minimum value for Gaussian sigmas

%numIterEM = 30;      % I think you can leave this fixed
numIterEM = P.ExOpt.numIterEM;      % I think you can leave this fixed
updateWeights = P.ExOpt.UpWeMeSi(1);
updateMeans  = P.ExOpt.UpWeMeSi(2);
updateSigmas = P.ExOpt.UpWeMeSi(3);

%
earlyStoppingK_EM = 3;
minSigma = 0.1;      % I think you can leave this fixed

%
% Run EM algorithm
%
[FL,TrNf]=size(XTr);
[FL,DevNf]=size(XDev);

TRAINX=XTr';
VALX=XDev';

% if length(unique(YTr))==1
%     TRAINL=zeros(1,TrNf);
%     VALL=zeros(1,DevNf);
% else
%     TRAINL=YTr;
%     VALL=YDev;
% end

LABELS{1} = YTr;
LABELS{2} = YDev;

TrNf=size(TRAINX,1);
DevNf=size(VALX,1);


%EMmodelFile = sprintf('%s_EM_%d_%d_%d.mod', modelFile(1:end-4), updateWeights, updateMeans, updateSigmas);
%  'outputLabels', LABELS,...  'outputLabels', LABELS,...

tic
fprintf('Tr and Dev: %d and %d samples\n',TrNf,DevNf);

[xx, history] = trainSPN_EM(modelFile, TRAINX, VALX, EMmodelFile, ...    
    'numIter', numIterEM, ...
    'outputLabels', LABELS,...
    'updateWeights', updateWeights, ...
    'updateMeans', updateMeans, ...
    'updateSigmas', updateSigmas, ...
    'minSigma', minSigma, ...
    'earlyStoppingK', earlyStoppingK_EM, ...
    'stop_relLikelihoodChange', -1e6,...
    'binPath', Bin_Path);

toc

%
PrintSpnLosF(XTr,YTr,XDev,YDev,EMmodelFile,'EM');
PrintSpnLosF(XTr,YTr,XDev,YDev,modelFile,'NoEM');






   

