function [LL,LS]=Forw1Spn(Fe,Un,Spn,MF,UnK,P)
%Forward for One Spn 
%Equivalent to Robert Forward but x4 faster due to matrix propagation
%LL: Log of root layer output
%LS: Log of each node output (used by BackProp)
%
%Fe: Featuregram (matrix, row feature, column time)
%Un: Uncertygram (matrix)
%Spn: Spn in Juan (not Robert) format. Remember! Spn.Si: Std=sqrt(Var); (not Var)
%MF: Minimum Floor for Missing Data can be a matrix or a scalar
%UnK: Uncertainty Kind. 'Spn' (Normal) 'UnSpn' (Uncertainty) 'MDSpn' (Missing Data)

%Spn elements
Idx=Spn.Idx;        %min and max linear Indexes per layer of the nodes 
ChIdx=Spn.ChIdx;    %Children Idx of each node (only for sum nodes)
Me=Spn.Me;          %Mean of the gaussians at botton layer
Si=Spn.Si;          %Standard Deviation (Si=Std=sqrt(Var); (not Var)) of the gaussians at botton layer
LW=Spn.LW;          %Log Weithg of the children
TNNod=Spn.TNNod;    %Total Number of Nodes. Should be equal to Idx(end,2)
NCh=Spn.NCh;        %Nomber of Children for every node.

%Allocate LS (Log of Spn node outputs). Big matrix of size [total_number_of_nodes,number_of_frames]
[nf]=size(Fe,2); %number of frames
LS=zeros(TNNod,nf); %Big matrix


%Evaluate gaussian layer
GChV=cell2mat(ChIdx{2})';

switch UnK
    case {'Sta','Spn'}
        A=EvGaus(Fe,Me,Si,GChV,nf);       
    case {'Un','UnSpn'}        
        A=EvGausUnc(Fe,Un,Me,Si,GChV,nf);
     case {'Un2','UnSpn2'}        
        A=EvGausUnc2(Fe,Un,Me,Si,GChV,nf,P);           
    case {'MD','MDSpn'}
        A=EvGausMD(Fe,Un,MF,Me,Si,GChV,nf);
end

LS(Idx(2,1):Idx(2,2),:)=CheckLogPr(A);

%Evaluate sum and product layers
NLay=size(Idx,1);
for i=3:NLay        
    LaLW=LW{i};    
    if isempty(LaLW)
        LS(Idx(i,1):Idx(i,2),:)=EvProdLa(LS,ChIdx{i},NCh{i},nf); 
    else
        LS(Idx(i,1):Idx(i,2),:)=EvSumLa(LS,ChIdx{i},NCh{i},LaLW,nf);
    end         
end

LL=LS(Idx(end,1):Idx(end,2),:);
LL=CheckLogPr(LL);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function LSu=EvSumLa(LS,ChIdx,NCh,LW,nf)
%
NNod=length(ChIdx);
na=1:NNod;
%
LSu=zeros(NNod,nf);
nn=na(NCh==1); 
LSu(nn,:)=LS(cell2mat(ChIdx(nn)),:);  

%
UNCh=unique(NCh(NCh>1))';
for nch=UNCh
    nn=na(NCh==nch);       
    chidx=cell2mat(ChIdx(nn));        
    w=cell2mat(LW(nn));   
    l=length(nn);     
    %Create 3D matrix
    W3D=repmat(reshape(w,[nch,1,l]),[1,nf,1]);    %fast            
    %X=LS(chidx,:);    C = mat2cell(X, repmat(nch,[1,l]), nf);    LX3D=cell2mat(reshape(C,[1,1,length(C)])); %slow
    %LX3D=zeros(nch,nf,l);   for k=1:l;        LX3D(:,:,k)=LS(chidx(:,k),:);    end %medium        
    X=LS(chidx,:);  LX3D=permute(reshape(X',nf,nch,l),[2 1 3]); %fast  
        
    %Compute    
    A=squeeze(LogDot(LX3D,W3D));
    LSu(nn,:)=shiftdim(A,1);   
    
end


function LPr=EvProdLa(LS,ChIdx,NCh,nf)
%
chidx=cell2mat(ChIdx);
[nch,l]=size(chidx);
X=LS(chidx,:); 
B=reshape(X,nch,nf*l); 
C=sum(B,1); %2D is faster than 3D sum
LPr=reshape(C,l,nf);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function LP=EvGaus(Fe,me,si,ChV,nf)
%si: Std (not var)
Y=Fe(ChV,:);
Me=repmat(me,[1,nf]);
Si=repmat(si,[1,nf]);
a=(Y-Me)./Si;
LP=-0.5*(a.^2+log(2*pi))-log(Si);



function LP=EvGausUnc2(Fe,Un,me,si,ChV,nf,P)
%si: Std (not var)
% nf=size(Fe,2);
% NG=length(ChV);
% De=sqrt(Un);
% LP=zeros(NG,nf);
% for g=1:NG
%     m=me(g);
%     s=si(g);
%     for n=1:nf
%         f=Fe(ChV(g),n);
%         d=De(ChV(g),n);         
%         a=log((normcdf(f+d,m,s)-normcdf(f-d,m,s))/(2*d));           
%        LP(g,n)=a;        
%     end        
% end
% i=isinf(LP); mi=min(LP(~i)); LP(i)=mi;

% %
% LPY=EvGaus(Fe,me,si,ChV,nf);
% LPX=EvGaus(P.TmpX,me,si,ChV,nf);
% U=YXCepHardMask((Fe),(P.TmpX),3);  U=U(ChV,:);
% LP=LPY; LP(U)=LPX(U);




%
Y=Fe(ChV,:);
D=sqrt(Un(ChV,:));
Me=repmat(me,[1,nf]);
Si=repmat(si,[1,nf]);
a=(normcdf(Y+D,Me,Si)-normcdf(Y-D,Me,Si))./(2*D);
LP=log(a); 
i=isinf(LP); LP(i)=min(LP(~i));




% subplot(311), jimagesc(Fe)
% subplot(312), jimagesc(P.TmpX)
% subplot(313), jimagesc(U)
% 222
% pause














% subplot(411), jimagesc(Fe)
% subplot(412), jimagesc(Un)
% subplot(413), jimagesc(LP)
% subplot(414), jimagesc(LP2)
% 344
% pause


function LP=EvGausUnc(Fe,Un,me,si,ChV,nf)
%si: Std (not var)
Y=Fe(ChV,:);
U=Un(ChV,:);
Me=repmat(me,[1,nf]);
Si=repmat(si,[1,nf]);
%
V=Si.^2+U; %Checked on GMMs
Si=sqrt(V);
a=(Y-Me)./Si;
LP=-0.5*(a.^2+log(2*pi))-log(Si);






function LP=EvGausMD(Fe,Un,MF,me,si,ChV,nf)
%si: Std (not var)
%MF: scalar or matrix (with same size as Fe)
Y=Fe(ChV,:);
Un=logical(Un); U=Un(ChV,:); 
Me=repmat(me,[1,nf]);
Si=repmat(si,[1,nf]);
if ismatrix(MF); MF=MF(ChV,:); end
%
a=(Y-Me)./Si;
LPr=-0.5*(a.^2+log(2*pi))-log(Si);
%
a=normcdf(Y,Me,Si)-normcdf(MF,Me,Si);
LPu=log(a); 
%LPu=log(a)-log(Y-MF); 

%
LP=LPu;
LP(U)=LPr(U);



function B=CheckLogPr(A)
%
i=isnan(A)|isinf(A)|~isreal(A);

s=sum(i(:));
B=A;
if s>0
    mi=min(A(not(i)));
    if ~isempty(mi)
        warning('Some LogPr bad values replaced by %d', mi)    
        B(i)=mi;
    else
        error('All LogPr bad values')
    end
end









