function [DW,DMe,DSi]=DLosFSpnBackP(Fe,LS,DLosFLSO,Spn)
%Derivative of a Loss Function w.r.t. Spn paremeters (weithts, mean and variances) 
%
%[DW,DMe,DSi] are dLosF/dw, dLosF/dMe, dLosF/dSi 
%
%Fe: Featuregram matrix (row feature, column time)
%LS: log(S), Log of each node output (used by BackProp)
%DLosFLSO: dLosF/dlog(p(x|so)) (derivative of LosF wrt Log of Spn Outputs)
%Spn: Spn in Juan (not Robert) format. Remember! Spn.Si: Std=sqrt(Var); (not Var)


%

Idx=Spn.Idx;        %min and max linear Indexes per layer of the nodes 
ChIdx=Spn.ChIdx;    %Children Idx of each node (only for sum nodes)
Me=Spn.Me;          %Mean of the gaussians at botton layer
Si=Spn.Si;          %Standard Deviation (Si=Std=sqrt(Var); (not Var)) of the gaussians at botton layer
LW=Spn.LW;          %Log Weithg of the children
TNNod=Spn.TNNod;    %Total Number of Nodes. Should be equal to Idx(end,2)
NCh=Spn.NCh;        %Nomber of Children for every node.
FaIdx=Spn.FaIdx;    %Father Indexes of each node 
FaLW=Spn.FaLW;      %Father Log Weights
ChFaNoIdx=Spn.ChFaNoIdx; %Children of the Father excluding actual Node Indexes
NFa=Spn.NFa;        %Number of Fathers
LayK=Spn.LayK;      %Layer Kind

%
[FL,nf]=size(Fe);
NLay=size(Idx,1);


%Exponentiations
FaW=LWNetFun(FaLW,'exp'); %log(w) to w (fathers weights)
S=exp(LS); %log(s) to s (nodes of SPN after foward) 

%Allocate derivatives of all nodes S (big matrix).
%DS will contatin the dLosF/ds (s is a node)
DS=zeros(TNNod,nf); 

%Since dLosF/dw=[dLos/dlog(p(x|so))] [1/p(x|so)] [dp(x|so)/ds] [ds/dw] 
%we initialize root layer with DLosFLSO/S(ind,:) to set the value of
%[dp(x|so)/ds] and start to apply backpropagation
ind=Idx(NLay,1):Idx(NLay,2); %indexes of root layer
DS(ind,:)=DLosFLSO./S(ind,:); %DLosFLSO is normal [-1,1], S is very small [0,1e-19]

%Derivative of sum, product and gaussian nodes
for l=NLay-1:-1:2 %start in NLay-1 because NLay is already done (at initialization of DS acording to DLosFLSO)
                  %stop in 2 (gauss layer) because 1 is the variable layer      
    ind=Idx(l,1):Idx(l,2);
    A=SumProdGausNodDer1Lay(DS,FaIdx{l},NFa{l},FaW{l},S,ChFaNoIdx{l},nf,LayK(l));  
    DS(ind,:)=A;    
    %To see mean value of DS
    %B=sign(A).*log(abs(A)); MeLDS(l)=mean(B(:));
    %B=LS(ind,:);   MeLS(l)=mean(B(:));
    
end



%Derivative of Weights, Means and Variances
DW=cell(NLay,1);
for l=NLay:-1:2  %now start in NLay because top layer is sum and we need to estimate DW
                 %l=2 to propagate derivatives to Gaussians
    ind=Idx(l,1):Idx(l,2);    
    switch LayK(l)
        case 's'   
            DW{l}=WeDer1Lay(DS(ind,:),S,ChIdx{l},NCh{l},nf); %The same if we do after    
        case 'g'
            [DMe,DSi]=MeSiDer1Lay(DS(ind,:),Fe,Me,Si,cell2mat(ChIdx{2})',nf);            
        otherwise  
            
    end      
end

% %Plot interesting mean values (per layer and derivatives)
% subplot(211), jplot(MeLDS)
% subplot(212), jplot(MeLS)
% pause
% MeDW=LWNetFun(DW,'LayMean');
% subplot(311), stem(MeDW)
% subplot(312), plot(DMe)
% subplot(313), plot(DSi)
% pause






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [DMe,DSi]=MeSiDer1Lay(DS,Fe,me,si,ChV,nf)
%Me and Si Derivatives of One Layer
%Local derivatives formulas of Me and Si checked with Wolfram Alpha
Y=Fe(ChV,:); 
Me=repmat(me,[1,nf]);
Si=repmat(si,[1,nf]);
%Local term
D=(Y-Me);
Pr=exp(-(D.^2)./(2*Si.^2))./(Si*sqrt(2*pi)); %Probability
LoMe=(D.*Pr)./Si.^2; %0.1447
LoSi=(D.^2.*Pr)./Si.^3 - Pr./Si;
%Recursive term with DS
Re=DS; 
%Finally
DMe=mean(Re.*LoMe,2); %Average over bactch samples     
DSi=mean(Re.*LoSi,2);



function DW=WeDer1Lay(DS,S,ChIdx,NCh,nf)
%Weight Derivatives of One Layer
NNod=size(DS,1);
DW=cell(1,NNod);
for n=1:NNod       
    Re=repmat(DS(n,:),[NCh(n) 1]); % Recursive term with DS
    Lo=S(ChIdx{n},:); % Local term     
    DW{n}=mean(Re.*Lo,2); %Average over batch samples            
end



function DSO=SumProdGausNodDer1Lay(DS,FaIdx,NFa,FaW,S,ChFaNoIdx,nf,LK)
%Sum, Product and Gaussian Node Derivatives for One Layer
NNod=length(FaIdx);
DSO=zeros(NNod,nf);
for n=1:NNod          
    Re=DS(FaIdx{n},:);  %Recursive   term with DS
    switch LK
        case 'p'            
            Lo=repmat(FaW{n},[1,nf]); %Local term           
        case {'s','g'}   
            Lo=S(ChFaNoIdx{n},:);                 
        otherwise
            warning('Unkonw layer')
    end   
    DSO(n,:)=sum(Re.*Lo,1); 
end




