function [DW,DMe,DSi]=DLosFSpn(X,Y,Spn,LPrior,LosFK)
%Derivative of a Loss Function w.r.t. Spn paremeters (weithts, mean and variances) 
% (the loss function is a function to minimize, not objective function)
%
%[DW,DMe,DSi] are dLosF/dw, dLosF/dMe, dLosF/dSi 
%
%X: features
%Y: corresponding output label or posteriors from 0 to NLab-1
%LPrior: Log Prior of Y
%LosFK: Loss Function Kind


%Forward
[LL,LS]=Forw1Spn(X,-1,Spn,-1,'Spn');

%Derivative Objective Function w.r.t. Log Spn Outputs (DLSO) 
DLosFLSO=DLosFLogSpnO(LL,Y,LPrior,LosFK);

%Compute derivatives with Back Propagation
[DW,DMe,DSi]=DLosFSpnBackP(X,LS,DLosFLSO,Spn);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%








