function [DLosFLSO,Loss]=DLosFLogSpnO(LL,Y,LPrior,LosFK)
%Derivative Loss Function w.r.t. Log Spn Outputs 
%
%DLosFLSO: dLosF/dlog(p(x|so)) 
%Loss: Average Loss (or error) per sample
%
%LL: Log Likelihood Spn output after foward,
%LPrior: Log Prior probabilities

%
[NOut,nf]=size(LL);

%Delta and Posterior Matrix
Idx=sub2ind([NOut,nf],Y+1,1:nf); %Index of true Y
DeltM=zeros(NOut,nf); DeltM(Idx)=1; %matrix value of root layer


%Posterior
if ~isempty(LPrior)
    LPriorM=repmat(LPrior,[1,nf]);
    LA=LPriorM+LL;
    LPoM=LA-log(repmat(sum(exp(LA)),[NOut 1]));
    PoM=exp(LPoM);
end

%
switch LosFK
    case 'NPseLik'     %minimize Negative of Pseudo Likelihood (equivalent to maximize Pseudo Likelihood)       
        DLosFLSO=-DeltM; 
        Loss=-mean(LL(Idx));        
        
   case 'CE' %minimize Cross Entropy (equivalent to maximize Posterior)        
        DLosFLSO=PoM-DeltM;
        Loss=-mean(LPoM(Idx));
        
    case 'NMMI' %minimize Negative MMI (equivalent to maximize MMI)      
        A=exp(LA);
        A(DeltM>0.5)=0;
        PoM=A./repmat(sum(A),[NOut 1]);        
        DLosFLSO=PoM-DeltM; 
        LPoM=log(PoM);
        Loss=-mean(LPoM(Idx));
end


