function DW=Back1Spn(X,Y,Spn)
%Backward in One Spn (matrix by matrix)
%Y: Posteriors or labels form 0 to NLab-1

%
Idx=Spn.Idx; 
ChIdx=Spn.ChIdx;
Me=Spn.Me;
Si=Spn.Si;
LW=Spn.LW;
TNNod=Spn.TNNod; %is equal to Idx(end,2)
NCh=Spn.NCh;
FaIdx=Spn.FaIdx;
FaLW=Spn.FaLW;
ChFaNoIdx=Spn.ChFaNoIdx;
NFa=Spn.NFa;

%
[FL,nf]=size(X);
NLay=size(Idx,1);

%Ini S
[LL,LS]=Forw1Spn(X,-1,Spn,-1,'Spn');


%Ini DS acording to labels
DS=zeros(TNNod,nf); %allocate derivative of all nodes. Big Matrix (last layer) 
ind=Idx(NLay,1):Idx(NLay,2); %indexes of root layer
A=zeros(length(ind),nf); A(sub2ind(size(A),Y+1,1:nf))=1; %vector value of root layer
DS(ind,:)=A; %set vector of root layer

%Ini DW as W (later we overwrite)
DW=cell(NLay,1);
%DW=LW;

%Derivative of sum and product nodes
for l=NLay-1:-1:2 %start in NLay-1 because NLay is already done (at initialization of DS acording to labels)
    ind=Idx(l,1):Idx(l,2);
    if ~isempty(FaLW{l}{1})
        LK='p';
    else
        LK='s';
    end    
    DS(ind,:)=SumProdLaDer(DS,FaIdx{l},NFa{l},FaLW{l},LS,ChFaNoIdx{l},nf,LK);      
end

% sum(isinf(DS(:)))
% sum(DS(:)<0)


%Derivative of weights
for l=NLay:-1:2  %now start in NLay because top layer is sum and we need to estimate DW
                 %l=2 to propagate derivatives to Gaussians
    ind=Idx(l,1):Idx(l,2);    
    if ~isempty(FaLW{l}{1})
        LK='p';
    else       
        LK='s';        
        DW{l}=WeLaDer(DS(ind,:),LS,ChIdx{l},NCh{l}); %The same if we do after             
    end      
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DW=WeLaDer(DSSu,LS,ChIdx,NCh)
%
NNod=size(DSSu,1);
DW=cell(1,NNod);
for n=1:NNod       
    A=repmat(DSSu(n,:),[NCh(n) 1]); %
    B=exp(LS(ChIdx{n},:)); %    
    C=mean(A.*B,2); %Average over samples       
    %C=A.*B; %Not average     
    DW{n}=C;          
end



function DSO=SumProdLaDer(DS,FaIdx,NFa,FaLW,LS,ChFaNoIdx,nf,LK)
%
NNod=length(FaIdx);
DSO=zeros(NNod,nf);
for n=1:NNod          
    Re=DS(FaIdx{n},:);  %Recursive   term 
    if LK=='p'
        Lo=repmat(exp(FaLW{n}),[1,nf]); %Local term    
    else        
        Lo=exp(LS(ChFaNoIdx{n},:));    
    end   
    DSO(n,:)=sum(Re.*Lo,1); %LogDotV2(LRe,LLo);    
end







function LcM=LogDotV2(LaM,LbM)
%Log Dot product using Logs (column by column)
%La=log(a); Lb=log(b); then Lc=log(dot(a,b));
%but more estable process if a and b are huge.
%Works for 3D arrays (LaM,LbM) 
%Other interpretation: a=exp(La); b=exp(Lb); Lc=log(dot(a,b)) %Equivalent to Lc
%Works for -Inf
% cM=dot(exp(LaM),exp(LbM));
% LcM=log(cM);
[FL,nf]=size(LaM);
LsM=LaM+LbM; %No inf
LmaxV=max(LsM); %-35.6586
%
LmaxV(isinf(LmaxV))=0;
%
LmaxM=repmat(LmaxV,[FL,1]);
a=exp(LsM-LmaxM); %No Inf
LcM=LmaxV+log(sum(a,1)); %In log the inf can appears 


